/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import java.util.Set;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;

public class MissingModsException
extends EnhancedRuntimeException {
    private static final long serialVersionUID = 1L;
    public final Set<ArtifactVersion> missingMods;
    private final String modName;

    public MissingModsException(Set<ArtifactVersion> missingMods, String id, String name) {
        super(String.format("Mod %s (%s) requires %s", id, name, missingMods));
        this.missingMods = missingMods;
        this.modName = name;
    }

    public String getModName() {
        return this.modName;
    }

    @Override
    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
        stream.println("Missing Mods:");
        for (ArtifactVersion v : this.missingMods) {
            stream.println(String.format("\t%s : %s", v.getLabel(), v.getRangeString()));
        }
        stream.println("");
    }
}

