/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.terraingen;

import java.util.Random;
import net.minecraftforge.event.world.WorldEvent;

public class InitNoiseGensEvent<T extends Context>
extends WorldEvent {
    private final Random rand;
    private final T original;
    private T newValues;

    public InitNoiseGensEvent(aid world, Random rand, T original) {
        super(world);
        this.rand = rand;
        this.original = original;
        this.newValues = ((Context)original).clone();
    }

    public Random getRandom() {
        return this.rand;
    }

    public T getOriginal() {
        return this.original;
    }

    public T getNewValues() {
        return this.newValues;
    }

    public static class ContextHell
    extends Context {
        private axn perlin2;
        private axn perlin3;

        public ContextHell(axn lperlin1, axn lperlin2, axn perlin, axn perlin2, axn perlin3, axn scale, axn depth) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.perlin2 = perlin2;
            this.perlin3 = perlin3;
        }

        @Override
        public ContextHell clone() {
            return new ContextHell(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.perlin2, this.perlin3, this.getScale(), this.getDepth());
        }

        public axn getPerlin2() {
            return this.perlin2;
        }

        public axn getPerlin3() {
            return this.perlin3;
        }

        public void getPerlin2(axn value) {
            this.perlin2 = value;
        }

        public void getPerlin3(axn value) {
            this.perlin3 = value;
        }
    }

    public static class ContextEnd
    extends Context {
        private axr island;

        public ContextEnd(axn lperlin1, axn lperlin2, axn perlin, axn scale, axn depth, axr island) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.island = island;
        }

        @Override
        public ContextEnd clone() {
            return new ContextEnd(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.getScale(), this.getDepth(), this.island);
        }

        public axr getIsland() {
            return this.island;
        }

        public void getIsland(axr value) {
            this.island = value;
        }
    }

    public static class ContextOverworld
    extends Context {
        private axo height;
        private axn forest;

        public ContextOverworld(axn lperlin1, axn lperlin2, axn perlin, axo height, axn scale, axn depth, axn forest) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.height = height;
            this.forest = forest;
        }

        @Override
        public ContextOverworld clone() {
            return new ContextOverworld(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.height, this.getScale(), this.getDepth(), this.forest);
        }

        public axo getHeight() {
            return this.height;
        }

        public axn getForest() {
            return this.forest;
        }

        public void getHeight(axo value) {
            this.height = value;
        }

        public void getForest(axn value) {
            this.forest = value;
        }
    }

    public static class Context {
        private axn lperlin1;
        private axn lperlin2;
        private axn perlin;
        private axn scale;
        private axn depth;

        public Context(axn lperlin1, axn lperlin2, axn perlin, axn scale, axn depth) {
            this.lperlin1 = lperlin1;
            this.lperlin2 = lperlin2;
            this.perlin = perlin;
            this.scale = scale;
            this.depth = depth;
        }

        public axn getLPerlin1() {
            return this.lperlin1;
        }

        public axn getLPerlin2() {
            return this.lperlin2;
        }

        public axn getPerlin() {
            return this.perlin;
        }

        public axn getScale() {
            return this.scale;
        }

        public axn getDepth() {
            return this.depth;
        }

        public void setLPerlin1(axn value) {
            this.lperlin1 = value;
        }

        public void getLPerlin2(axn value) {
            this.lperlin2 = value;
        }

        public void getPerlin(axn value) {
            this.perlin = value;
        }

        public void getScale(axn value) {
            this.scale = value;
        }

        public void getDepth(axn value) {
            this.depth = value;
        }

        public Context clone() {
            return new Context(this.lperlin1, this.lperlin2, this.perlin, this.scale, this.depth);
        }
    }
}

