/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.io.Serializable;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockSnapshot
implements Serializable {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockSnapshot", "false"));
    private final cm pos;
    private final int dimId;
    private transient ars replacedBlock;
    private int flag;
    private final dr nbt;
    private transient aid world;
    private final kn registryName;
    private final int meta;

    public BlockSnapshot(aid world, cm pos, ars state) {
        this.setWorld(world);
        this.dimId = world.s.getDimension();
        this.pos = pos;
        this.setReplacedBlock(state);
        this.registryName = state.t().getRegistryName();
        this.meta = state.t().e(state);
        this.setFlag(3);
        aqk te = world.r(pos);
        if (te != null) {
            this.nbt = new dr();
            te.b(this.getNbt());
        } else {
            this.nbt = null;
        }
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.T().j(), pos.p(), pos.q(), pos.r(), this.getRegistryName(), this.getMeta());
        }
    }

    public BlockSnapshot(aid world, cm pos, ars state, dr nbt) {
        this.setWorld(world);
        this.dimId = world.s.getDimension();
        this.pos = pos.h();
        this.setReplacedBlock(state);
        this.registryName = state.t().getRegistryName();
        this.meta = state.t().e(state);
        this.setFlag(3);
        this.nbt = nbt;
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.T().j(), pos.p(), pos.q(), pos.r(), this.getRegistryName(), this.getMeta());
        }
    }

    public BlockSnapshot(aid world, cm pos, ars state, int flag) {
        this(world, pos, state);
        this.setFlag(flag);
    }

    public BlockSnapshot(int dimension, cm pos, String modId, String blockName, int meta, int flag, dr nbt) {
        this.dimId = dimension;
        this.pos = pos.h();
        this.setFlag(flag);
        this.registryName = new kn(modId, blockName);
        this.meta = meta;
        this.nbt = nbt;
    }

    public static BlockSnapshot getBlockSnapshot(aid world, cm pos) {
        return new BlockSnapshot(world, pos, world.o(pos));
    }

    public static BlockSnapshot getBlockSnapshot(aid world, cm pos, int flag) {
        return new BlockSnapshot(world, pos, world.o(pos), flag);
    }

    public static BlockSnapshot readFromNBT(dr tag) {
        dr nbt = tag.p("hasTE") ? null : tag.o("tileEntity");
        return new BlockSnapshot(tag.h("dimension"), new cm(tag.h("posX"), tag.h("posY"), tag.h("posZ")), tag.l("blockMod"), tag.l("blockName"), tag.h("metadata"), tag.h("flag"), nbt);
    }

    public ars getCurrentBlock() {
        return this.getWorld().o(this.getPos());
    }

    public aid getWorld() {
        if (this.world == null) {
            this.world = DimensionManager.getWorld(this.getDimId());
        }
        return this.world;
    }

    public ars getReplacedBlock() {
        if (this.replacedBlock == null) {
            this.replacedBlock = GameRegistry.findBlock(this.getRegistryName().b(), this.getRegistryName().a()).a(this.getMeta());
        }
        return this.replacedBlock;
    }

    public aqk getTileEntity() {
        if (this.getNbt() != null) {
            return aqk.a((aid)this.getWorld(), (dr)this.getNbt());
        }
        return null;
    }

    public boolean restore() {
        return this.restore(false);
    }

    public boolean restore(boolean force) {
        return this.restore(force, true);
    }

    public boolean restore(boolean force, boolean applyPhysics) {
        ars current = this.getCurrentBlock();
        ars replaced = this.getReplacedBlock();
        if (current.t() != replaced.t() || current.t().e(current) != replaced.t().e(replaced)) {
            if (force) {
                this.getWorld().a(this.getPos(), replaced, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        this.getWorld().a(this.getPos(), replaced, applyPhysics ? 3 : 2);
        this.getWorld().a(this.getPos(), current, replaced, applyPhysics ? 3 : 2);
        aqk te = null;
        if (this.getNbt() != null && (te = this.getWorld().r(this.getPos())) != null) {
            te.a(this.getNbt());
            te.v_();
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][applyPhysics: %s]", this.getWorld().T().j(), this.getPos().p(), this.getPos().q(), this.getPos().r(), replaced.t().e(replaced), replaced.t().delegate.name(), te, force, applyPhysics);
        }
        return true;
    }

    public boolean restoreToLocation(aid world, cm pos, boolean force, boolean applyPhysics) {
        ars current = this.getCurrentBlock();
        ars replaced = this.getReplacedBlock();
        if (current.t() != replaced.t() || current.t().e(current) != replaced.t().e(replaced)) {
            if (force) {
                world.a(pos, replaced, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        world.a(pos, replaced, applyPhysics ? 3 : 2);
        world.a(pos, current, replaced, applyPhysics ? 3 : 2);
        aqk te = null;
        if (this.getNbt() != null && (te = world.r(pos)) != null) {
            te.a(this.getNbt());
            te.v_();
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][applyPhysics: %s]", world.T().j(), pos.p(), pos.q(), pos.r(), replaced.t().e(replaced), replaced.t().delegate.name(), te, force, applyPhysics);
        }
        return true;
    }

    public void writeToNBT(dr compound) {
        compound.a("blockMod", this.getRegistryName().b());
        compound.a("blockName", this.getRegistryName().a());
        compound.a("posX", this.getPos().p());
        compound.a("posY", this.getPos().q());
        compound.a("posZ", this.getPos().r());
        compound.a("flag", this.getFlag());
        compound.a("dimension", this.getDimId());
        compound.a("metadata", this.getMeta());
        compound.a("hasTE", this.getNbt() != null);
        if (this.getNbt() != null) {
            compound.a("tileEntity", (ef)this.getNbt());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockSnapshot other = (BlockSnapshot)obj;
        if (!this.getPos().equals((Object)other.getPos())) {
            return false;
        }
        if (this.getMeta() != other.getMeta()) {
            return false;
        }
        if (this.getDimId() != other.getDimId()) {
            return false;
        }
        if (!(this.getNbt() == other.getNbt() || this.getNbt() != null && this.getNbt().equals((Object)other.getNbt()))) {
            return false;
        }
        if (!(this.getWorld() == other.getWorld() || this.getWorld() != null && this.getWorld().equals(other.getWorld()))) {
            return false;
        }
        return this.getRegistryName() == other.getRegistryName() || this.getRegistryName() != null && this.getRegistryName().equals((Object)other.getRegistryName());
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.getPos().p();
        hash = 73 * hash + this.getPos().q();
        hash = 73 * hash + this.getPos().r();
        hash = 73 * hash + this.getMeta();
        hash = 73 * hash + this.getDimId();
        hash = 73 * hash + (this.getNbt() != null ? this.getNbt().hashCode() : 0);
        hash = 73 * hash + (this.getWorld() != null ? this.getWorld().hashCode() : 0);
        hash = 73 * hash + (this.getRegistryName() != null ? this.getRegistryName().hashCode() : 0);
        return hash;
    }

    public cm getPos() {
        return this.pos;
    }

    public int getDimId() {
        return this.dimId;
    }

    public void setReplacedBlock(ars replacedBlock) {
        this.replacedBlock = replacedBlock;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public dr getNbt() {
        return this.nbt;
    }

    public void setWorld(aid world) {
        this.world = world;
    }

    public kn getRegistryName() {
        return this.registryName;
    }

    public int getMeta() {
        return this.meta;
    }
}

