/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.recipe;

import de.eydamos.backpack.recipe.ECategory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.RecipeSorter;

public abstract class AbstractRecipe
implements IRecipe {
    protected final int recipeWidth;
    protected final int recipeHeight;
    protected int colOffset = 0;
    protected int rowOffset = 0;
    protected ItemStack[] recipeItems;
    private final ItemStack recipeOutput;
    private final String recipeSorterIdentifier;
    private final ECategory type;

    public AbstractRecipe(int width, int height, ItemStack output, String identifier) {
        this(width, height, output, identifier, ECategory.SHAPED);
    }

    public AbstractRecipe(int width, int height, ItemStack output, String identifier, ECategory type) {
        this.recipeWidth = width;
        this.recipeHeight = height;
        this.recipeOutput = output;
        this.recipeSorterIdentifier = identifier;
        this.type = type;
        if (type == ECategory.CUSTOM || type == ECategory.FURNACE) {
            throw new IllegalArgumentException("Only shaped and shapeless types are allowed");
        }
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public ItemStack[] func_179532_b(InventoryCrafting craftingGridInventory) {
        ItemStack[] remainingItems = new ItemStack[craftingGridInventory.func_70302_i_()];
        for (int i = 0; i < remainingItems.length; ++i) {
            ItemStack itemstack = craftingGridInventory.func_70301_a(i);
            remainingItems[i] = ForgeHooks.getContainerItem((ItemStack)itemstack);
        }
        return remainingItems;
    }

    public boolean func_77569_a(InventoryCrafting craftingGridInventory, World world) {
        if (this.type == ECategory.SHAPED || this.type == ECategory.SHAPED_OREDICT) {
            this.colOffset = 0;
            while (this.colOffset <= craftingGridInventory.func_174922_i() - this.recipeWidth) {
                this.rowOffset = 0;
                while (this.rowOffset <= craftingGridInventory.func_174923_h() - this.recipeHeight) {
                    if (this.checkMatch(craftingGridInventory)) {
                        return true;
                    }
                    ++this.rowOffset;
                }
                ++this.colOffset;
            }
        }
        if (this.type == ECategory.SHAPELESS || this.type == ECategory.SHAPELESS_OREDICT) {
            boolean breakLoop = false;
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    if (this.checkItemAtPosition(craftingGridInventory, col, row, 0, 0)) continue;
                    breakLoop = true;
                    break;
                }
                if (breakLoop) break;
            }
            return this.allRecipeItemsFulfilled();
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting craftingGridInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int expectedCol = col - this.colOffset;
                int expectedRow = row - this.rowOffset;
                ItemStack itemStack = craftingGridInventory.func_70463_b(col, row);
                if (expectedCol < 0 || expectedCol >= this.recipeWidth || expectedRow < 0 || expectedRow >= this.recipeHeight) {
                    if (itemStack == null) continue;
                    return false;
                }
                if (this.checkItemAtPosition(craftingGridInventory, col, row, expectedCol, expectedRow)) continue;
                return false;
            }
        }
        return true;
    }

    public int func_77570_a() {
        return this.recipeWidth * this.recipeHeight;
    }

    protected abstract boolean checkItemAtPosition(InventoryCrafting var1, int var2, int var3, int var4, int var5);

    protected boolean allRecipeItemsFulfilled() {
        return true;
    }

    public void registerAtRecipeSorter() {
        switch (this.type) {
            case SHAPELESS: 
            case SHAPELESS_OREDICT: {
                RecipeSorter.register((String)this.recipeSorterIdentifier, this.getClass(), (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
            }
        }
        RecipeSorter.register((String)this.recipeSorterIdentifier, this.getClass(), (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
    }
}

