/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.item;

import java.util.Hashtable;

public enum EStick {
    STONE(0, "stone"),
    IRON(1, "iron");

    private static Hashtable<Integer, String> VARIANTS;
    private final int damage;
    private final String identifier;

    private EStick(int damage, String identifier) {
        this.damage = damage;
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getDamage() {
        return this.damage;
    }

    public static String getIdentifierByDamage(int damage) {
        for (EStick stick : EStick.values()) {
            if (stick.getDamage() != damage) continue;
            return stick.identifier;
        }
        return "";
    }

    public static Hashtable<Integer, String> getVariants() {
        return VARIANTS;
    }

    static {
        VARIANTS = new Hashtable();
        for (EStick stick : EStick.values()) {
            VARIANTS.put(stick.getDamage(), stick.getIdentifier());
        }
    }
}

