/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.item;

import java.util.Hashtable;

public enum EFrame {
    WOOD(0, "wood"),
    STONE(1, "stone"),
    IRON(2, "iron");

    private static Hashtable<Integer, String> VARIANTS;
    private final int damage;
    private final String identifier;

    private EFrame(int damage, String identifier) {
        this.damage = damage;
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getDamage() {
        return this.damage;
    }

    public static String getIdentifierByDamage(int damage) {
        for (EFrame frame : EFrame.values()) {
            if (frame.getDamage() != damage) continue;
            return frame.identifier;
        }
        return "";
    }

    public static Hashtable<Integer, String> getVariants() {
        return VARIANTS;
    }

    static {
        VARIANTS = new Hashtable();
        for (EFrame frame : EFrame.values()) {
            VARIANTS.put(frame.getDamage(), frame.getIdentifier());
        }
    }
}

