/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostRegistry;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.core.proxy.Proxies;
import forestry.core.utils.PlayerUtil;
import forestry.mail.Letter;
import forestry.mail.LetterProperties;
import forestry.mail.MailAddress;
import forestry.mail.POBox;
import forestry.mail.PluginMail;
import forestry.mail.PostOffice;
import forestry.mail.TradeStation;
import forestry.mail.network.packets.PacketPOBoxInfoUpdate;
import java.io.File;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class PostRegistry
implements IPostRegistry {
    public static PostOffice cachedPostOffice;
    public static final Map<IMailAddress, POBox> cachedPOBoxes;
    public static final Map<IMailAddress, ITradeStation> cachedTradeStations;
    private final Map<EnumAddressee, IPostalCarrier> carriers = new EnumMap<EnumAddressee, IPostalCarrier>(EnumAddressee.class);

    @Override
    public boolean isValidPOBox(World world, IMailAddress address) {
        return address.getType() == EnumAddressee.PLAYER && address.getName().matches("^[a-zA-Z0-9]+$");
    }

    public static POBox getPOBox(World world, IMailAddress address) {
        if (cachedPOBoxes.containsKey(address)) {
            return cachedPOBoxes.get(address);
        }
        POBox pobox = (POBox)world.func_72943_a(POBox.class, "POBox_" + address);
        if (pobox != null) {
            cachedPOBoxes.put(address, pobox);
        }
        return pobox;
    }

    public static POBox getOrCreatePOBox(World world, IMailAddress address) {
        POBox pobox = PostRegistry.getPOBox(world, address);
        if (pobox == null) {
            pobox = new POBox(address);
            world.func_72823_a("POBox_" + address, (WorldSavedData)pobox);
            pobox.func_70296_d();
            cachedPOBoxes.put(address, pobox);
            EntityPlayer player = PlayerUtil.getPlayer(world, address.getPlayerProfile());
            if (player != null) {
                Proxies.net.sendToPlayer(new PacketPOBoxInfoUpdate(pobox.getPOBoxInfo()), player);
            }
        }
        return pobox;
    }

    @Override
    public boolean isValidTradeAddress(World world, IMailAddress address) {
        return address != null && address.getType() == EnumAddressee.TRADER && address.getName().matches("^[a-zA-Z0-9]+$");
    }

    @Override
    public boolean isAvailableTradeAddress(World world, IMailAddress address) {
        return address != null && this.getTradeStation(world, address) == null;
    }

    @Override
    public TradeStation getTradeStation(World world, IMailAddress address) {
        if (address == null || address.getName() == null) {
            return null;
        }
        if (cachedTradeStations.containsKey(address)) {
            return (TradeStation)cachedTradeStations.get(address);
        }
        TradeStation trade = (TradeStation)world.func_72943_a(TradeStation.class, "TradePO_" + address);
        if (trade != null && trade.isValid()) {
            cachedTradeStations.put(address, trade);
            this.getPostOffice(world).registerTradeStation(trade);
            return trade;
        }
        return null;
    }

    @Override
    public TradeStation getOrCreateTradeStation(World world, GameProfile owner, IMailAddress address) {
        TradeStation trade = this.getTradeStation(world, address);
        if (trade == null) {
            trade = new TradeStation(owner, address);
            world.func_72823_a("TradePO_" + address, (WorldSavedData)trade);
            trade.func_70296_d();
            cachedTradeStations.put(address, trade);
            this.getPostOffice(world).registerTradeStation(trade);
        }
        return trade;
    }

    @Override
    public void deleteTradeStation(World world, IMailAddress address) {
        TradeStation trade = this.getTradeStation(world, address);
        if (trade == null) {
            return;
        }
        trade.invalidate();
        cachedTradeStations.remove(address);
        this.getPostOffice(world).deregisterTradeStation(trade);
        File file = world.func_72860_G().func_75758_b(trade.field_76190_i);
        file.delete();
    }

    @Override
    public IPostOffice getPostOffice(World world) {
        if (cachedPostOffice != null) {
            return cachedPostOffice;
        }
        PostOffice office = (PostOffice)world.func_72943_a(PostOffice.class, "ForestryMail");
        if (office == null) {
            office = new PostOffice();
            world.func_72823_a("ForestryMail", (WorldSavedData)office);
        }
        office.setWorld(world);
        cachedPostOffice = office;
        return office;
    }

    @Override
    @Nonnull
    public IMailAddress getMailAddress(@Nonnull GameProfile gameProfile) {
        return new MailAddress(gameProfile);
    }

    @Override
    public IMailAddress getMailAddress(@Nonnull String traderName) {
        return new MailAddress(traderName);
    }

    @Override
    public Map<EnumAddressee, IPostalCarrier> getRegisteredCarriers() {
        return this.carriers;
    }

    @Override
    public void registerCarrier(IPostalCarrier carrier) {
        this.carriers.put(carrier.getType(), carrier);
    }

    @Override
    public IPostalCarrier getCarrier(EnumAddressee type) {
        return this.carriers.get((Object)type);
    }

    @Override
    public ILetter createLetter(IMailAddress sender, IMailAddress recipient) {
        return new Letter(sender, recipient);
    }

    @Override
    public ItemStack createLetterStack(ILetter letter) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        letter.writeToNBT(nbttagcompound);
        ItemStack letterStack = LetterProperties.createStampedLetterStack(letter);
        letterStack.func_77982_d(nbttagcompound);
        return letterStack;
    }

    @Override
    public ILetter getLetter(ItemStack itemstack) {
        if (itemstack == null) {
            return null;
        }
        if (!PostManager.postRegistry.isLetter(itemstack)) {
            return null;
        }
        if (itemstack.func_77978_p() == null) {
            return null;
        }
        return new Letter(itemstack.func_77978_p());
    }

    @Override
    public boolean isLetter(ItemStack itemstack) {
        return itemstack != null && itemstack.func_77973_b() == PluginMail.items.letters;
    }

    static {
        cachedPOBoxes = new HashMap<IMailAddress, POBox>();
        cachedTradeStations = new HashMap<IMailAddress, ITradeStation>();
    }
}

