/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.proxy;

import forestry.api.core.ForestryAPI;
import forestry.core.models.BlockModelEntry;
import forestry.core.proxy.Proxies;
import forestry.greenhouse.PluginGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.models.ModelGreenhouse;
import forestry.greenhouse.proxy.ProxyGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouseSprinkler;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraftforge.client.model.animation.AnimationTESR;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ProxyGreenhouseClient
extends ProxyGreenhouse {
    @Override
    public void initializeModels() {
        for (BlockGreenhouseType greenhouseType : BlockGreenhouseType.VALUES) {
            if (greenhouseType == BlockGreenhouseType.DOOR) {
                Proxies.render.registerBlockModel(new BlockModelEntry(new ModelResourceLocation("forestry:greenhouse." + (Object)((Object)greenhouseType), "camouflage"), null, new ModelGreenhouse(), PluginGreenhouse.blocks.getGreenhouseBlock(greenhouseType), false));
                continue;
            }
            if (greenhouseType == BlockGreenhouseType.SPRINKLER) {
                ClientRegistry.bindTileEntitySpecialRenderer(TileGreenhouseSprinkler.class, (TileEntitySpecialRenderer)new AnimationTESR());
                continue;
            }
            if (greenhouseType != BlockGreenhouseType.BUTTERFLY_HATCH ? greenhouseType == BlockGreenhouseType.WINDOW || greenhouseType == BlockGreenhouseType.WINDOW_UP : !ForestryAPI.enabledPlugins.contains("forestry.lepidopterology")) continue;
            BlockGreenhouse greenhouseBlock = PluginGreenhouse.blocks.getGreenhouseBlock(greenhouseType);
            if (greenhouseBlock == null) continue;
            ModelResourceLocation blockModelLocation = new ModelResourceLocation("forestry:greenhouse." + (Object)((Object)greenhouseType));
            ModelResourceLocation itemModelLocation = new ModelResourceLocation("forestry:greenhouse", "inventory");
            BlockModelEntry blockModelIndex = new BlockModelEntry(blockModelLocation, itemModelLocation, new ModelGreenhouse(), greenhouseBlock);
            Proxies.render.registerBlockModel(blockModelIndex);
        }
    }
}

