/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.api.genetics.IIndividual;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.core.utils.GeneticsUtil;
import forestry.farming.logic.CropDestroy;
import forestry.farming.logic.FarmableCocoa;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FarmableVanillaSapling
implements IFarmable {
    protected final ItemStack germling = new ItemStack(Blocks.field_150345_g);
    private final ItemStack[] windfall = new ItemStack[]{new ItemStack(Items.field_151034_e), new ItemStack(FarmableCocoa.COCOA_SEED, 1, 3)};

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
        if (ForestryAPI.enabledPlugins.contains("forestry.arboriculture")) {
            IIndividual tree = GeneticsUtil.getGeneticEquivalent(germling);
            if (!(tree instanceof ITree)) {
                return false;
            }
            return TreeManager.treeRoot.plantSapling(world, (ITree)tree, player.func_146103_bH(), pos);
        }
        EnumActionResult actionResult = germling.func_77946_l().func_179546_a(player, world, pos.func_177977_b(), EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
        if (actionResult == EnumActionResult.SUCCESS) {
            PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.SoundFXType.BLOCK_PLACE, pos, Blocks.field_150345_g.func_176223_P());
            Proxies.net.sendNetworkPacket(packet, world);
            return true;
        }
        return false;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == Blocks.field_150345_g;
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos, IBlockState blockState) {
        Block block = blockState.func_177230_c();
        if (!block.isWood((IBlockAccess)world, pos)) {
            return null;
        }
        return new CropDestroy(world, blockState, pos, null);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return ItemStack.func_179545_c((ItemStack)this.germling, (ItemStack)itemstack);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        for (ItemStack drop : this.windfall) {
            if (!drop.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }
}

