/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import com.google.common.collect.ImmutableSet;
import forestry.api.farming.FarmDirection;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class FarmHelper {
    public static final ImmutableSet<Block> bricks = ImmutableSet.of((Object)Blocks.field_150336_V, (Object)Blocks.field_150417_aV, (Object)Blocks.field_150322_A, (Object)Blocks.field_150385_bj, (Object)Blocks.field_150371_ca);

    private static FarmDirection getOpposite(FarmDirection farmDirection) {
        EnumFacing forgeDirection = farmDirection.getFacing();
        EnumFacing forgeDirectionOpposite = forgeDirection.func_176734_d();
        return FarmDirection.getFarmDirection(forgeDirectionOpposite);
    }

    public static BlockPos getFarmMultiblockCorner(BlockPos start, FarmDirection farmSide, FarmDirection layoutDirection, BlockPos minFarmCoord, BlockPos maxFarmCoord) {
        BlockPos edge = FarmHelper.getFarmMultiblockEdge(start, farmSide, maxFarmCoord, minFarmCoord);
        return FarmHelper.getFarmMultiblockEdge(edge, FarmHelper.getOpposite(layoutDirection), maxFarmCoord, minFarmCoord);
    }

    private static BlockPos getFarmMultiblockEdge(BlockPos start, FarmDirection direction, BlockPos maxFarmCoord, BlockPos minFarmCoord) {
        switch (direction) {
            case NORTH: {
                return new BlockPos(start.func_177958_n(), start.func_177956_o(), minFarmCoord.func_177952_p());
            }
            case EAST: {
                return new BlockPos(maxFarmCoord.func_177958_n(), start.func_177956_o(), start.func_177952_p());
            }
            case SOUTH: {
                return new BlockPos(start.func_177958_n(), start.func_177956_o(), maxFarmCoord.func_177952_p());
            }
            case WEST: {
                return new BlockPos(minFarmCoord.func_177958_n(), start.func_177956_o(), start.func_177952_p());
            }
        }
        throw new IllegalArgumentException("Invalid farm direction: " + (Object)((Object)direction));
    }
}

