/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.squeezer;

import forestry.factory.recipes.ISqueezerContainerRecipe;
import forestry.factory.recipes.jei.squeezer.AbstractSqueezerRecipeWrapper;
import java.util.Collections;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class SqueezerContainerRecipeWrapper
extends AbstractSqueezerRecipeWrapper<ISqueezerContainerRecipe> {
    @Nonnull
    private final ItemStack filledContainer;

    public SqueezerContainerRecipeWrapper(@Nonnull ISqueezerContainerRecipe recipe, @Nonnull ItemStack filledContainer) {
        super(recipe);
        this.filledContainer = filledContainer;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        FluidStack fluidContained;
        ingredients.setInputs(ItemStack.class, Collections.singletonList(this.filledContainer));
        ItemStack remnants = ((ISqueezerContainerRecipe)this.getRecipe()).getRemnants();
        if (remnants != null) {
            ingredients.setOutput(ItemStack.class, (Object)remnants);
        }
        if ((fluidContained = FluidUtil.getFluidContained((ItemStack)this.filledContainer)) != null) {
            ingredients.setOutput(FluidStack.class, (Object)fluidContained);
        }
    }

    @Override
    public float getRemnantsChance() {
        return ((ISqueezerContainerRecipe)this.getRecipe()).getRemnantsChance();
    }
}

