/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.network.packets;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketCoordinates;
import forestry.core.tiles.TileBase;
import forestry.factory.tiles.TileCarpenter;
import forestry.factory.tiles.TileFabricator;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketRecipeTransferUpdate
extends PacketCoordinates
implements IForestryPacketClient {
    private ItemStack[] craftingInventory;

    public PacketRecipeTransferUpdate() {
    }

    public PacketRecipeTransferUpdate(TileBase base, ItemStack[] craftingInventory) {
        super(base);
        this.craftingInventory = craftingInventory;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeItemStacks(this.craftingInventory);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.craftingInventory = data.readItemStacks();
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        block3: {
            TileEntity tile;
            block2: {
                tile = this.getTarget(player.field_70170_p);
                if (!(tile instanceof TileCarpenter)) break block2;
                TileCarpenter carpenter = (TileCarpenter)tile;
                int index = 0;
                for (ItemStack stack : this.craftingInventory) {
                    carpenter.getCraftingInventory().func_70299_a(index, stack);
                    ++index;
                }
                break block3;
            }
            if (!(tile instanceof TileFabricator)) break block3;
            TileFabricator fabricator = (TileFabricator)tile;
            int index = 0;
            for (ItemStack stack : this.craftingInventory) {
                fabricator.getCraftingInventory().func_70299_a(index, stack);
                ++index;
            }
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.RECIPE_TRANSFER_UPDATE;
    }
}

