/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.mojang.authlib.GameProfile;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.ILocatable;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.MultiblockControllerBase;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public abstract class MultiblockControllerForestry
extends MultiblockControllerBase
implements ISidedInventory,
IOwnedTile,
IErrorLogicSource,
ILocatable {
    private final OwnerHandler ownerHandler = new OwnerHandler();
    private final IErrorLogic errorLogic = ForestryAPI.errorStateRegistry.createErrorLogic();

    protected MultiblockControllerForestry(World world) {
        super(world);
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    @Override
    public World getWorldObj() {
        return this.worldObj;
    }

    @Override
    protected void onMachineAssembled() {
        super.onMachineAssembled();
        if (this.worldObj.field_72995_K) {
            return;
        }
        HashMultiset owners = HashMultiset.create();
        for (IMultiblockComponent part : this.connectedParts) {
            GameProfile owner = part.getOwner();
            if (owner == null) continue;
            owners.add((Object)owner);
        }
        GameProfile owner = null;
        int max = 0;
        for (Multiset.Entry entry : owners.entrySet()) {
            int count = entry.getCount();
            if (count <= max) continue;
            max = count;
            owner = (GameProfile)entry.getElement();
        }
        if (owner != null) {
            this.getOwnerHandler().setOwner(owner);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        this.ownerHandler.writeToNBT(data);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.ownerHandler.readFromNBT(data);
    }

    @Nonnull
    public IInventoryAdapter getInternalInventory() {
        return FakeInventoryAdapter.instance();
    }

    public void func_70296_d() {
        this.getInternalInventory().func_70296_d();
    }

    public final int func_70302_i_() {
        return this.getInternalInventory().func_70302_i_();
    }

    public final ItemStack func_70301_a(int slotIndex) {
        return this.getInternalInventory().func_70301_a(slotIndex);
    }

    public final ItemStack func_70298_a(int slotIndex, int amount) {
        return this.getInternalInventory().func_70298_a(slotIndex, amount);
    }

    public ItemStack func_70304_b(int slotIndex) {
        return this.getInternalInventory().func_70304_b(slotIndex);
    }

    public final void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().func_70299_a(slotIndex, itemstack);
    }

    public final int func_70297_j_() {
        return this.getInternalInventory().func_70297_j_();
    }

    public final void func_174889_b(EntityPlayer player) {
        this.getInternalInventory().func_174889_b(player);
    }

    public final void func_174886_c(EntityPlayer player) {
        this.getInternalInventory().func_174886_c(player);
    }

    public String func_70005_c_() {
        return this.getInternalInventory().func_70005_c_();
    }

    public ITextComponent func_145748_c_() {
        return this.getInternalInventory().func_145748_c_();
    }

    public final boolean func_70300_a(EntityPlayer player) {
        return this.getInternalInventory().func_70300_a(player);
    }

    public boolean func_145818_k_() {
        return this.getInternalInventory().func_145818_k_();
    }

    public final boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().func_94041_b(slotIndex, itemStack);
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.getInternalInventory().func_180463_a(side);
    }

    public final boolean func_180462_a(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return this.getInternalInventory().func_180462_a(slotIndex, itemStack, side);
    }

    public final boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return this.getInternalInventory().func_180461_b(slotIndex, itemStack, side);
    }

    public int func_174887_a_(int id) {
        return this.getInternalInventory().func_174887_a_(id);
    }

    public int func_174890_g() {
        return this.getInternalInventory().func_174890_g();
    }

    public void func_174885_b(int id, int value) {
        this.getInternalInventory().func_174885_b(id, value);
    }

    public void func_174888_l() {
        this.getInternalInventory().func_174888_l();
    }
}

