/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory.manipulators;

import forestry.core.inventory.iterators.IInvSlot;
import forestry.core.inventory.iterators.InvIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerInventoryManipulator
implements Iterable<IInvSlot> {
    private final IItemHandler inv;

    public ItemHandlerInventoryManipulator(IItemHandler inv) {
        this.inv = inv;
    }

    @Override
    public Iterator<IInvSlot> iterator() {
        return new InvIterator(this.inv);
    }

    @Nullable
    public ItemStack tryAddStack(ItemStack stack) {
        return this.addStack(stack, false);
    }

    @Nullable
    public ItemStack addStack(ItemStack stack) {
        return this.addStack(stack, true);
    }

    public ItemStack removeItem(Predicate<ItemStack> filter) {
        for (IInvSlot slot : this) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || stack.field_77994_a <= 0 || !slot.canTakeStackFromSlot(stack) || !filter.test(stack)) continue;
            return slot.decreaseStackInSlot();
        }
        return null;
    }

    public boolean transferOneStack(IItemHandler dest, Predicate<ItemStack> filter) {
        return this.transferStacks(dest, filter, true);
    }

    public boolean transferStacks(IItemHandler dest, Predicate<ItemStack> filter) {
        return this.transferStacks(dest, filter, false);
    }

    private boolean transferStacks(IItemHandler dest, Predicate<ItemStack> filter, boolean singleStack) {
        ItemHandlerInventoryManipulator destManipulator = new ItemHandlerInventoryManipulator(dest);
        boolean stacksMoved = false;
        for (int slotIndex = 0; slotIndex < this.inv.getSlots(); ++slotIndex) {
            ItemStack targetStack = this.inv.extractItem(slotIndex, Integer.MAX_VALUE, true);
            if (targetStack == null || targetStack.field_77994_a <= 0 || !filter.test(targetStack)) continue;
            int extractStackSize = targetStack.field_77994_a;
            ItemStack remaining = destManipulator.tryAddStack(targetStack);
            if (remaining != null) {
                extractStackSize -= remaining.field_77994_a;
            }
            if (extractStackSize <= 0) continue;
            ItemStack extracted = this.inv.extractItem(slotIndex, extractStackSize, false);
            destManipulator.addStack(extracted);
            stacksMoved = true;
            if (!singleStack) continue;
            return true;
        }
        return stacksMoved;
    }

    @Nullable
    protected ItemStack addStack(ItemStack stack, boolean doAdd) {
        if (stack == null || stack.field_77994_a <= 0) {
            return null;
        }
        stack = stack.func_77946_l();
        ArrayList<IInvSlot> filledSlots = new ArrayList<IInvSlot>(this.inv.getSlots());
        ArrayList<IInvSlot> emptySlots = new ArrayList<IInvSlot>(this.inv.getSlots());
        for (IInvSlot slot : new ItemHandlerInventoryManipulator(this.inv)) {
            if (!slot.canPutStackInSlot(stack)) continue;
            if (slot.getStackInSlot() == null) {
                emptySlots.add(slot);
                continue;
            }
            filledSlots.add(slot);
        }
        int injected = 0;
        injected = this.tryPut(filledSlots, stack, injected, doAdd);
        injected = this.tryPut(emptySlots, stack, injected, doAdd);
        stack.field_77994_a -= injected;
        if (stack.field_77994_a <= 0) {
            return null;
        }
        return stack;
    }

    private int tryPut(List<IInvSlot> slots, ItemStack stack, int injected, boolean doAdd) {
        if (injected >= stack.field_77994_a) {
            return injected;
        }
        for (IInvSlot slot : slots) {
            int stackToInsertSize;
            ItemStack stackToInsert = stack.func_77946_l();
            stackToInsert.field_77994_a = stackToInsertSize = stack.field_77994_a - injected;
            ItemStack remainder = this.inv.insertItem(slot.getIndex(), stackToInsert, !doAdd);
            if (remainder == null) {
                return stack.field_77994_a;
            }
            if ((injected += stackToInsertSize - remainder.field_77994_a) < stack.field_77994_a) continue;
            return injected;
        }
        return injected;
    }
}

