/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import forestry.api.core.IErrorState;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import javax.annotation.Nullable;

public class ErrorLedger
extends Ledger {
    @Nullable
    private IErrorState state;

    public ErrorLedger(LedgerManager manager) {
        super(manager, "error", false);
        this.maxHeight = 72;
    }

    public void setState(@Nullable IErrorState state) {
        this.state = state;
        if (state != null) {
            int lineHeight = StringUtil.getLineHeight(this.maxTextWidth, this.getTooltip(), Translator.translateToLocal(state.getUnlocalizedHelp()));
            this.maxHeight = lineHeight + 20;
        }
    }

    @Override
    public void draw(int x, int y) {
        if (this.state == null) {
            return;
        }
        this.drawBackground(x, y);
        int xIcon = x + 5;
        int xBody = x + 14;
        int xHeader = x + 24;
        this.drawSprite(this.state.getSprite(), xIcon, y += 4);
        y += 4;
        if (this.isFullyOpened()) {
            y += this.drawHeader(this.getTooltip(), xHeader, y);
            String helpString = Translator.translateToLocal(this.state.getUnlocalizedHelp());
            this.drawSplitText(helpString, xBody, y += 4, this.maxTextWidth);
        }
    }

    @Override
    public boolean isVisible() {
        return this.state != null;
    }

    @Override
    public String getTooltip() {
        if (!this.isVisible()) {
            return "";
        }
        return Translator.translateToLocal(this.state.getUnlocalizedDescription());
    }
}

