/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.IClimateControl;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;

public class ClimateControl
implements IClimateControl,
INbtWritable,
INbtReadable,
IStreamable {
    private float temperature = 2.0f;
    private float humidity = 2.0f;

    @Override
    public float getControlTemperature() {
        return this.temperature;
    }

    @Override
    public float getControlHumidity() {
        return this.humidity;
    }

    @Override
    public void setControlTemperature(float temperature) {
        if (temperature > 2.0f) {
            temperature = 2.0f;
        } else {
            this.temperature = temperature;
        }
    }

    @Override
    public void setControlHumidity(float humidity) {
        if (humidity > 2.0f) {
            humidity = 2.0f;
        } else {
            this.humidity = humidity;
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeFloat(this.temperature);
        data.writeFloat(this.humidity);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.temperature = data.readFloat();
        this.humidity = data.readFloat();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.temperature = nbt.func_74760_g("Temperature");
        this.humidity = nbt.func_74760_g("Humidity");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74776_a("Temperature", this.temperature);
        nbt.func_74776_a("Humidity", this.humidity);
        return nbt;
    }
}

