/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ICircuitSocketType;
import forestry.core.utils.Translator;
import javax.annotation.Nonnull;

public class CircuitLayout
implements ICircuitLayout {
    @Nonnull
    private final String uid;
    @Nonnull
    private final ICircuitSocketType socketType;

    public CircuitLayout(@Nonnull String uid, @Nonnull ICircuitSocketType socketType) {
        this.uid = uid;
        this.socketType = socketType;
    }

    @Override
    @Nonnull
    public String getUID() {
        return "forestry." + this.uid;
    }

    @Override
    @Nonnull
    public String getName() {
        return Translator.translateToLocal("for.circuit.layout." + this.uid + ".name");
    }

    @Override
    @Nonnull
    public String getUsage() {
        return Translator.translateToLocal("for.circuit.layout." + this.uid + ".usage");
    }

    @Override
    @Nonnull
    public ICircuitSocketType getSocketType() {
        return this.socketType;
    }
}

