/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenWillow
extends WorldGenTree {
    public WorldGenWillow(ITreeGenData tree) {
        super(tree, 5, 2);
    }

    @Override
    @Nonnull
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.8f, null, 0.0f);
        WorldGenHelper.generateSupportStems(wood, world, rand, startPos, this.height, this.girth, 0.2f, 0.2f);
        for (int leafSpawn = this.height - 4; leafSpawn > 2; --leafSpawn) {
            if ((leafSpawn - 3) % 6 != 0) continue;
            WorldGenHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, leafSpawn, 0), this.girth, 0.0f, 0.0f, 2, 1, 1.0f);
        }
        return Collections.emptySet();
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
        int leafSpawn = this.height + 1;
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1.5f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 2.5f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 3.0f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 3.0f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        while (leafSpawn > 2) {
            WorldGenHelper.generateCircleFromTreeStartPos(world, rand, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 4.0f, 2, 1, leaf, 1.0f, WorldGenHelper.EnumReplaceMode.AIR);
        }
        WorldGenHelper.generateCircleFromTreeStartPos(world, rand, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 4.0f, 1, 1, leaf, 1.0f, WorldGenHelper.EnumReplaceMode.AIR);
        WorldGenHelper.generateCircleFromTreeStartPos(world, rand, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 4.0f, 1, 1, leaf, 1.0f, WorldGenHelper.EnumReplaceMode.AIR);
        WorldGenHelper.generateCircleFromTreeStartPos(world, rand, startPos.func_177982_a(0, leafSpawn, 0), this.girth, 4.0f, 1, 1, leaf, 0.4f, WorldGenHelper.EnumReplaceMode.AIR);
    }
}

