/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenSilverLime
extends WorldGenTree {
    public WorldGenSilverLime(ITreeGenData tree) {
        super(tree, 6, 4);
    }

    @Override
    @Nonnull
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        BlockPos pos = startPos.func_177982_a(0, 3 + rand.nextInt(1), 0);
        return WorldGenHelper.generateBranches(world, rand, wood, pos, this.girth, 0.25f, 0.1f, Math.round((float)this.height * 0.25f), 2, 0.5f);
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
        for (BlockPos branchEnd : branchEnds) {
            WorldGenHelper.generateCylinderFromPos(world, leaf, branchEnd, this.girth, 1, WorldGenHelper.EnumReplaceMode.AIR);
        }
        int leafSpawn = this.height + 1;
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        float radius = 1.0f;
        while (leafSpawn > 1) {
            WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, radius + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
            radius = (float)((double)radius + 0.25);
        }
    }
}

