/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import forestry.api.arboriculture.EnumPileType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.blocks.BlockPile;
import forestry.arboriculture.tiles.TilePile;
import forestry.core.items.ItemBlockForestry;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.Translator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBlockPile<B extends Block>
extends ItemBlockForestry<Block> {
    public ItemBlockPile(Block block) {
        super(block);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    @Override
    public B func_179223_d() {
        return super.func_179223_d();
    }

    @Override
    public int func_77647_b(int i) {
        return i;
    }

    public String func_77653_i(ItemStack itemstack) {
        if (this.field_150939_a == PluginArboriculture.blocks.piles.get((Object)EnumPileType.WOOD)) {
            if (!itemstack.func_77942_o()) {
                return "Unknown";
            }
            IAlleleTreeSpecies species = BlockPile.getTreeSpecies(itemstack);
            if (species == null) {
                return "Unknown";
            }
            String customTreeKey = "for.trees.custom.pile." + species.getUnlocalizedName().replace("trees.species.", "");
            if (Translator.canTranslateToLocal(customTreeKey)) {
                return Translator.translateToLocal(customTreeKey);
            }
            String typeString = Translator.translateToLocal("for.trees.grammar.pile.type");
            return Translator.translateToLocal("for.trees.grammar.pile").replaceAll("%SPECIES", species.getName()).replaceAll("%TYPE", typeString);
        }
        return Translator.translateToLocal("for.trees.pile.dirt");
    }

    @Override
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        TilePile tile;
        boolean placed = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (placed && this.field_150939_a == PluginArboriculture.blocks.piles.get((Object)EnumPileType.WOOD) && this.field_150939_a.hasTileEntity(newState) && stack.func_77942_o() && (tile = TileUtil.getTile((IBlockAccess)world, pos, TilePile.class)) != null) {
            tile.func_145839_a(stack.func_77978_p());
            tile.func_174878_a(pos);
            tile.func_70296_d();
        }
        return placed;
    }
}

