/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks.planks;

import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.arboriculture.blocks.planks.BlockForestryPlanks;
import forestry.arboriculture.blocks.property.PropertyForestryWoodType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class BlockArbPlanks
extends BlockForestryPlanks<EnumForestryWoodType> {
    public static List<BlockArbPlanks> create(boolean fireproof) {
        ArrayList<BlockArbPlanks> blocks = new ArrayList<BlockArbPlanks>();
        PropertyForestryWoodType[] variants = PropertyForestryWoodType.create("variant", 16);
        for (int i = 0; i < variants.length; ++i) {
            final PropertyForestryWoodType variant = variants[i];
            BlockArbPlanks block = new BlockArbPlanks(fireproof, i){

                @Nonnull
                public PropertyForestryWoodType getVariant() {
                    return variant;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    private BlockArbPlanks(boolean fireproof, int blockNumber) {
        super(fireproof, blockNumber);
    }

    @Override
    @Nonnull
    public EnumForestryWoodType getWoodType(int meta) {
        int variantCount = this.getVariant().func_177700_c().size();
        int variantMeta = meta % variantCount + this.getBlockNumber() * 16;
        return EnumForestryWoodType.byMetadata(variantMeta);
    }
}

