/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.apiculture.genetics.BeeGenome;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import forestry.core.items.IColoredItem;
import forestry.core.utils.Translator;
import java.util.List;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBeeGE
extends ItemGE
implements IColoredItem {
    private final EnumBeeType type;

    public ItemBeeGE(EnumBeeType type) {
        super(Tabs.tabApiculture);
        this.type = type;
        if (type != EnumBeeType.DRONE) {
            this.func_77625_d(1);
        }
    }

    @Override
    public IBee getIndividual(ItemStack itemstack) {
        return BeeManager.beeRoot.getMember(itemstack);
    }

    @Override
    protected IAlleleSpecies getSpecies(ItemStack itemStack) {
        return BeeGenome.getSpecies(itemStack);
    }

    public String func_77653_i(ItemStack itemstack) {
        if (itemstack.func_77978_p() == null) {
            return super.func_77653_i(itemstack);
        }
        IBee individual = BeeManager.beeRoot.getMember(itemstack);
        String customBeeKey = "for.bees.custom." + this.type.getName() + "." + individual.getGenome().getPrimary().getUnlocalizedName().replace("bees.species.", "");
        if (Translator.canTranslateToLocal(customBeeKey)) {
            return Translator.translateToLocal(customBeeKey);
        }
        String beeGrammar = Translator.translateToLocal("for.bees.grammar." + this.type.getName());
        String beeSpecies = individual.getDisplayName();
        String beeType = Translator.translateToLocal("for.bees.grammar." + this.type.getName() + ".type");
        return beeGrammar.replaceAll("%SPECIES", beeSpecies).replaceAll("%TYPE", beeType);
    }

    @Override
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List<String> list, boolean flag) {
        if (!itemstack.func_77942_o()) {
            return;
        }
        if (this.type != EnumBeeType.DRONE) {
            IBee individual = BeeManager.beeRoot.getMember(itemstack);
            if (individual.isNatural()) {
                list.add(TextFormatting.YELLOW + TextFormatting.ITALIC.toString() + Translator.translateToLocal("for.bees.stock.pristine"));
            } else {
                list.add(TextFormatting.YELLOW + Translator.translateToLocal("for.bees.stock.ignoble"));
            }
        }
        super.func_77624_a(itemstack, player, list, flag);
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
        this.addCreativeItems(itemList, true);
    }

    public void addCreativeItems(List<ItemStack> itemList, boolean hideSecrets) {
        for (IBee bee : BeeManager.beeRoot.getIndividualTemplates()) {
            ItemStack beeStack;
            if (hideSecrets && bee.isSecret() && !Config.isDebug || (beeStack = BeeManager.beeRoot.getMemberStack(bee, this.type)) == null) continue;
            itemList.add(beeStack);
        }
    }

    @Override
    public int getColorFromItemstack(ItemStack itemstack, int tintIndex) {
        if (!itemstack.func_77942_o()) {
            if (tintIndex == 1) {
                return 16768022;
            }
            return 0xFFFFFF;
        }
        IAlleleBeeSpecies species = BeeGenome.getSpecies(itemstack);
        if (species instanceof IAlleleBeeSpecies) {
            return species.getSpriteColour(tintIndex);
        }
        return 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColourFromSpecies(IAlleleSpecies species, int renderPass) {
        if (species instanceof IAlleleBeeSpecies) {
            return species.getSpriteColour(renderPass);
        }
        return 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies)) continue;
            ((IAlleleBeeSpecies)allele).registerModels(item, manager);
        }
        manager.registerItemModel(item, new BeeMeshDefinition());
    }

    public final EnumBeeType getType() {
        return this.type;
    }

    private class BeeMeshDefinition
    implements ItemMeshDefinition {
        private BeeMeshDefinition() {
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            IAlleleBeeSpecies species = (IAlleleBeeSpecies)ItemBeeGE.this.getSpecies(stack);
            if (species == null) {
                species = (IAlleleBeeSpecies)BeeManager.beeRoot.getDefaultTemplate()[EnumBeeChromosome.SPECIES.ordinal()];
            }
            return species.getModel(ItemBeeGE.this.type);
        }
    }
}

