/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.worldgen;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.BlockRegistry;
import com.pam.harvestcraft.blocks.blocks.BlockBaseGarden;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class BushWorldWorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int xChunk = chunkX * 16 + 8;
        int zChunk = chunkZ * 16 + 8;
        int xCh = chunkX * 16 + random.nextInt(16);
        int yCh = random.nextInt(128);
        int zCh = chunkZ * 16 + random.nextInt(16);
        Biome biome = world.func_180494_b(new BlockPos(xChunk + 16, 0, zChunk + 16));
        BlockPos blockPos = new BlockPos(xCh, yCh + 64, zCh);
        if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
            return;
        }
        if (HarvestCraft.config.enablearidgardenGeneration && BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA)) {
            this.generateGarden(BlockRegistry.getGarden("aridGarden"), world, blockPos);
        }
        if (HarvestCraft.config.enablefrostgardenGeneration && BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
            this.generateGarden(BlockRegistry.getGarden("frostGarden"), world, blockPos);
        }
        if (HarvestCraft.config.enableshadedgardenGeneration && BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)) {
            this.generateGarden(BlockRegistry.getGarden("shadedGarden"), world, blockPos);
        }
        if (HarvestCraft.config.enablesoggygardenGeneration && BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
            this.generateGarden(BlockRegistry.getGarden("soggyGarden"), world, blockPos);
        }
        if (HarvestCraft.config.enabletropicalgardenGeneration && BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            this.generateGarden(BlockRegistry.getGarden("tropicalGarden"), world, blockPos);
        }
        if (HarvestCraft.config.enablewindygardenGeneration && BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
            this.generateGarden(BlockRegistry.getGarden("windyGarden"), world, blockPos);
        }
    }

    private void generateGarden(BlockBaseGarden gardenBlock, World world, BlockPos pos) {
        int tries = 32 * HarvestCraft.config.gardenRarity;
        for (int tryNum = 0; tryNum < tries; ++tryNum) {
            int posZ;
            int posY;
            int posX = pos.func_177958_n() + world.field_73012_v.nextInt(8) - world.field_73012_v.nextInt(8);
            BlockPos newPos = new BlockPos(posX, posY = pos.func_177956_o() + world.field_73012_v.nextInt(4) - world.field_73012_v.nextInt(4), posZ = pos.func_177952_p() + world.field_73012_v.nextInt(8) - world.field_73012_v.nextInt(8));
            if (!gardenBlock.func_176196_c(world, newPos)) continue;
            world.func_180501_a(newPos, gardenBlock.func_176223_P(), 2);
        }
    }
}

