/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.tileentities;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.CropRegistry;
import com.pam.harvestcraft.blocks.FruitRegistry;
import com.pam.harvestcraft.tileentities.MarketData;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class MarketItems {
    private static final ArrayList<MarketData> items = new ArrayList();

    private static void registerItems(MarketData data) {
        items.add(data);
    }

    public static MarketData getData(int i) {
        return items.get(i);
    }

    public static int getSize() {
        return items.size();
    }

    public static void registerItems() {
        if (HarvestCraft.config.marketsellSeeds) {
            MarketItems.registerSeeds();
        }
        if (HarvestCraft.config.marketselltemperateSaplings) {
            MarketItems.registerTemperateSaplings();
        }
        if (HarvestCraft.config.marketselltropicalSaplings) {
            MarketItems.registerTropicalSaplings();
        }
        if (HarvestCraft.config.marketsellconiferousSaplings) {
            MarketItems.registerConiferousSaplings();
        }
        MarketItems.registerAnimalEggs();
        if (HarvestCraft.config.marketsellBonemeal) {
            MarketItems.registerBonemeal();
        }
    }

    private static void registerBonemeal() {
        ItemStack currency = MarketItems.getCurrency(HarvestCraft.config.marketcurrencyBonemeal, CurrencyType.DEFAULT);
        MarketItems.registerItems(new MarketData(new ItemStack(Items.field_151100_aR, 1, 15), currency, HarvestCraft.config.marketbonemealPrice));
    }

    private static void registerAnimalEggs() {
        ItemStack currency;
        ItemStack pigEgg = new ItemStack(Items.field_151063_bx, 1, 90);
        ItemStack sheepEgg = new ItemStack(Items.field_151063_bx, 1, 91);
        ItemStack cowEgg = new ItemStack(Items.field_151063_bx, 1, 92);
        ItemStack chickenEgg = new ItemStack(Items.field_151063_bx, 1, 93);
        ItemStack horseEgg = new ItemStack(Items.field_151063_bx, 1, 100);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            ItemMonsterPlacer.func_185078_a((ItemStack)pigEgg, (String)EntityList.func_188430_a(EntityPig.class));
            ItemMonsterPlacer.func_185078_a((ItemStack)sheepEgg, (String)EntityList.func_188430_a(EntitySheep.class));
            ItemMonsterPlacer.func_185078_a((ItemStack)cowEgg, (String)EntityList.func_188430_a(EntityCow.class));
            ItemMonsterPlacer.func_185078_a((ItemStack)chickenEgg, (String)EntityList.func_188430_a(EntityChicken.class));
            ItemMonsterPlacer.func_185078_a((ItemStack)horseEgg, (String)EntityList.func_188430_a(EntityHorse.class));
        }
        if (HarvestCraft.config.marketsellPig) {
            currency = MarketItems.getCurrency(HarvestCraft.config.marketcurrencyPig, CurrencyType.ANIMAL);
            MarketItems.registerItems(new MarketData(pigEgg, currency, HarvestCraft.config.marketpigPrice));
        }
        if (HarvestCraft.config.marketsellSheep) {
            currency = MarketItems.getCurrency(HarvestCraft.config.marketcurrencySheep, CurrencyType.ANIMAL);
            MarketItems.registerItems(new MarketData(sheepEgg, currency, HarvestCraft.config.marketsheepPrice));
        }
        if (HarvestCraft.config.marketsellCow) {
            currency = MarketItems.getCurrency(HarvestCraft.config.marketcurrencyCow, CurrencyType.ANIMAL);
            MarketItems.registerItems(new MarketData(cowEgg, currency, HarvestCraft.config.marketcowPrice));
        }
        if (HarvestCraft.config.marketsellChicken) {
            currency = MarketItems.getCurrency(HarvestCraft.config.marketcurrencyChicken, CurrencyType.ANIMAL);
            MarketItems.registerItems(new MarketData(chickenEgg, currency, HarvestCraft.config.marketchickenPrice));
        }
        if (HarvestCraft.config.marketsellHorse) {
            currency = MarketItems.getCurrency(HarvestCraft.config.marketcurrencyHorse, CurrencyType.ANIMAL);
            MarketItems.registerItems(new MarketData(horseEgg, currency, HarvestCraft.config.markethorsePrice));
        }
    }

    private static void registerConiferousSaplings() {
        ItemStack currency = MarketItems.getCurrency(HarvestCraft.config.marketcurrencyconiferousSaplings, CurrencyType.SAPLING);
        MarketItems.registerItems(new MarketData(new ItemStack((Block)FruitRegistry.getSapling("maple"), 1), currency, HarvestCraft.config.marketsaplingPrice));
        MarketItems.registerItems(new MarketData(new ItemStack(Blocks.field_150345_g, 1, 1), currency, HarvestCraft.config.marketsaplingPrice));
    }

    private static void registerTropicalSaplings() {
        ItemStack currency = MarketItems.getCurrency(HarvestCraft.config.marketcurrencytropicalSaplings, CurrencyType.SAPLING);
        for (Block block : FruitRegistry.warmSaplings.values()) {
            MarketItems.registerItems(new MarketData(new ItemStack(block, 1), currency, HarvestCraft.config.marketsaplingPrice));
        }
        MarketItems.registerItems(new MarketData(new ItemStack((Block)FruitRegistry.getSapling("cinnamon"), 1), currency, HarvestCraft.config.marketsaplingPrice));
        MarketItems.registerItems(new MarketData(new ItemStack((Block)FruitRegistry.getSapling("paperbark"), 1), currency, HarvestCraft.config.marketsaplingPrice));
        MarketItems.registerItems(new MarketData(new ItemStack(Blocks.field_150345_g, 1, 3), currency, HarvestCraft.config.marketsaplingPrice));
        MarketItems.registerItems(new MarketData(new ItemStack(Blocks.field_150345_g, 1, 4), currency, HarvestCraft.config.marketsaplingPrice));
    }

    private static void registerTemperateSaplings() {
        ItemStack currency = MarketItems.getCurrency(HarvestCraft.config.marketcurrencytemperateSaplings, CurrencyType.SAPLING);
        for (Block block : FruitRegistry.temperateSaplings.values()) {
            MarketItems.registerItems(new MarketData(new ItemStack(block, 1), currency, HarvestCraft.config.marketsaplingPrice));
        }
        MarketItems.registerItems(new MarketData(new ItemStack(Blocks.field_150345_g, 1, 0), currency, HarvestCraft.config.marketsaplingPrice));
        MarketItems.registerItems(new MarketData(new ItemStack(Blocks.field_150345_g, 1, 2), currency, HarvestCraft.config.marketsaplingPrice));
        MarketItems.registerItems(new MarketData(new ItemStack(Blocks.field_150345_g, 1, 5), currency, HarvestCraft.config.marketsaplingPrice));
    }

    private static void registerSeeds() {
        ItemStack currency = MarketItems.getCurrency(HarvestCraft.config.marketcurrencySeeds, CurrencyType.SEEDS);
        for (Item seed : CropRegistry.getSeeds().values()) {
            MarketItems.registerItems(new MarketData(new ItemStack(seed), currency, HarvestCraft.config.marketseedPrice));
        }
        MarketItems.registerItems(new MarketData(new ItemStack(Items.field_151014_N), currency, HarvestCraft.config.marketseedPrice));
        MarketItems.registerItems(new MarketData(new ItemStack(Items.field_151080_bb), currency, HarvestCraft.config.marketseedPrice));
        MarketItems.registerItems(new MarketData(new ItemStack(Items.field_151081_bc), currency, HarvestCraft.config.marketseedPrice));
    }

    private static ItemStack getCurrency(int config, CurrencyType currencyType) {
        switch (config) {
            case 1: {
                return new ItemStack(Items.field_151045_i);
            }
            case 2: {
                return new ItemStack(Items.field_151043_k);
            }
            case 3: {
                return new ItemStack(Items.field_151074_bl);
            }
            case 4: {
                return new ItemStack(Items.field_151042_j);
            }
            case 5: {
                if (currencyType.equals((Object)CurrencyType.ANIMAL)) {
                    return new ItemStack(Items.field_151110_aK);
                }
                if (currencyType.equals((Object)CurrencyType.SEEDS)) {
                    return new ItemStack(Items.field_151014_N);
                }
                if (currencyType.equals((Object)CurrencyType.SAPLING)) {
                    return new ItemStack(Blocks.field_150345_g);
                }
                return null;
            }
            case 6: {
                return new ItemStack(Items.field_151034_e);
            }
            case 7: {
                return new ItemStack(Items.field_151100_aR);
            }
        }
        return new ItemStack(Items.field_151166_bC);
    }

    private static enum CurrencyType {
        DEFAULT,
        SEEDS,
        SAPLING,
        ANIMAL;

    }
}

