/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.plant;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeresources.jei.JEIConfig;
import jeresources.jei.plant.PlantWrapper;
import jeresources.reference.Resources;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import net.minecraft.item.ItemStack;

public class PlantCategory
extends BlankRecipeCategory<PlantWrapper> {
    private static final int GRASS_X = 79;
    private static final int GRASS_Y = 10;
    private static final int OUTPUT_X = 6;
    private static final int OUTPUT_SCALE = 20;
    private static final int OUTPUT_Y = 60;
    private IDrawable icon = JEIConfig.getJeiHelpers().getGuiHelper().createDrawable(Resources.Gui.Jei.TABS, 0, 16, 16, 16);

    @Nonnull
    public String getUid() {
        return "jeresources.plant";
    }

    @Nonnull
    public String getTitle() {
        return TranslationHelper.translateToLocal("jer.plant.title");
    }

    @Nonnull
    public IDrawable getBackground() {
        return Resources.Gui.Jei.PLANT;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull PlantWrapper recipeWrapper) {
        int i;
        recipeLayout.getItemStacks().init(0, true, 79, 10);
        int xOffset = 0;
        int yOffset = 0;
        for (i = 0; i < recipeWrapper.getOutputs().size(); ++i) {
            recipeLayout.getItemStacks().init(i + 1, false, 6 + xOffset, 60 + yOffset);
            if ((xOffset += 20) <= 147) continue;
            xOffset = 0;
            yOffset += 20;
        }
        recipeLayout.getItemStacks().setFromRecipe(0, recipeWrapper.getInputs());
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)recipeWrapper);
        for (i = 0; i < recipeWrapper.getOutputs().size(); ++i) {
            recipeLayout.getItemStacks().set(i + 1, recipeWrapper.getDrops().get(i));
        }
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull PlantWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        int i;
        recipeLayout.getItemStacks().init(0, true, 79, 10);
        int xOffset = 0;
        int yOffset = 0;
        for (i = 0; i < ingredients.getOutputs(ItemStack.class).size(); ++i) {
            recipeLayout.getItemStacks().init(i + 1, false, 6 + xOffset, 60 + yOffset);
            if ((xOffset += 20) <= 147) continue;
            xOffset = 0;
            yOffset += 20;
        }
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(ItemStack.class).get(0));
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)recipeWrapper);
        for (i = 0; i < ingredients.getOutputs(ItemStack.class).size(); ++i) {
            recipeLayout.getItemStacks().set(i + 1, (ItemStack)ingredients.getOutputs(ItemStack.class).get(i));
        }
    }
}

