/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.proxy;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.util.concurrent.Callable;
import mcjty.lib.McJtyLib;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.varia.WrenchChecker;
import mcjty.xnet.XNet;
import mcjty.xnet.apiimpl.energy.EnergyChannelType;
import mcjty.xnet.apiimpl.fluids.FluidChannelType;
import mcjty.xnet.apiimpl.items.ItemChannelType;
import mcjty.xnet.apiimpl.logic.LogicChannelType;
import mcjty.xnet.config.GeneralConfiguration;
import mcjty.xnet.gui.GuiProxy;
import mcjty.xnet.init.ModBlocks;
import mcjty.xnet.init.ModItems;
import mcjty.xnet.init.ModRecipes;
import mcjty.xnet.network.XNetMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.logging.log4j.Level;

public abstract class CommonProxy {
    public static File modConfigDir;
    private Configuration mainConfig;

    public void preInit(FMLPreInitializationEvent e) {
        McJtyLib.preInit((FMLPreInitializationEvent)e);
        GeneralConfig.preInit((FMLPreInitializationEvent)e);
        modConfigDir = e.getModConfigurationDirectory();
        this.mainConfig = new Configuration(new File(modConfigDir.getPath() + File.separator + "xnet", "xnet.cfg"));
        this.readMainConfig();
        SimpleNetworkWrapper network = PacketHandler.registerMessages((String)"xnet", (String)"xnet");
        XNetMessages.registerNetworkMessages(network);
        ModItems.init();
        ModBlocks.init();
        XNet.xNetApi.registerChannelType(new ItemChannelType());
        XNet.xNetApi.registerChannelType(new EnergyChannelType());
        XNet.xNetApi.registerChannelType(new FluidChannelType());
        XNet.xNetApi.registerChannelType(new LogicChannelType());
    }

    private void readMainConfig() {
        Configuration cfg = this.mainConfig;
        try {
            cfg.load();
            cfg.addCustomCategoryComment("general", "General settings");
            GeneralConfiguration.init(cfg);
        }
        catch (Exception e1) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e1, (String)"Problem loading config file!", (Object[])new Object[0]);
        }
        finally {
            if (this.mainConfig.hasChanged()) {
                this.mainConfig.save();
            }
        }
    }

    public void init(FMLInitializationEvent e) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)XNet.instance, (IGuiHandler)new GuiProxy());
        ModRecipes.init();
    }

    public void postInit(FMLPostInitializationEvent e) {
        this.mainConfig = null;
        WrenchChecker.init();
    }

    public World getClientWorld() {
        throw new IllegalStateException("This should only be called from client side");
    }

    public EntityPlayer getClientPlayer() {
        throw new IllegalStateException("This should only be called from client side");
    }

    public <V> ListenableFuture<V> addScheduledTaskClient(Callable<V> callableToSchedule) {
        throw new IllegalStateException("This should only be called from client side");
    }

    public ListenableFuture<Object> addScheduledTaskClient(Runnable runnableToSchedule) {
        throw new IllegalStateException("This should only be called from client side");
    }
}

