/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mcjty.lib.network.ClientCommandHandler;
import mcjty.lib.network.PacketListFromServer;
import mcjty.lib.varia.Logging;
import mcjty.typed.Type;
import mcjty.xnet.XNet;
import mcjty.xnet.clientinfo.ChannelClientInfo;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketChannelsReady
extends PacketListFromServer<PacketChannelsReady, ChannelClientInfo> {
    public PacketChannelsReady() {
    }

    public PacketChannelsReady(BlockPos pos, String command, List<ChannelClientInfo> list) {
        super(pos, command, list);
    }

    protected ChannelClientInfo createItem(ByteBuf buf) {
        if (buf.readBoolean()) {
            return new ChannelClientInfo(buf);
        }
        return null;
    }

    protected void writeItemToBuf(ByteBuf buf, ChannelClientInfo item) {
        if (item == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            item.writeToNBT(buf);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketChannelsReady, IMessage> {
        public IMessage onMessage(PacketChannelsReady message, MessageContext ctx) {
            XNet.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketChannelsReady message, MessageContext ctx) {
            TileEntity te = XNet.proxy.getClientWorld().func_175625_s(message.pos);
            ClientCommandHandler clientCommandHandler = (ClientCommandHandler)te;
            if (!clientCommandHandler.execute(message.command, message.list, Type.create(ChannelClientInfo.class))) {
                Logging.log((String)("Command " + message.command + " was not handled!"));
            }
        }
    }
}

