/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.logic;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import mcjty.xnet.blocks.router.TileEntityRouter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RouterIterator
implements Iterator<TileEntityRouter> {
    @Nonnull
    private final World world;
    @Nonnull
    private final BlockPos pos;
    private int facingIdx = 0;
    private TileEntityRouter foundRouter = null;

    Stream<TileEntityRouter> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this, (long)EnumFacing.field_82609_l.length, 16), false);
    }

    RouterIterator(@Nonnull World world, @Nonnull BlockPos pos) {
        this.world = world;
        this.pos = pos;
        this.findNext();
    }

    private void findNext() {
        this.foundRouter = null;
        while (this.facingIdx != -1) {
            TileEntity te;
            BlockPos routerPos = this.pos.func_177972_a(EnumFacing.field_82609_l[this.facingIdx]);
            ++this.facingIdx;
            if (this.facingIdx >= EnumFacing.field_82609_l.length) {
                this.facingIdx = -1;
            }
            if (!((te = this.world.func_175625_s(routerPos)) instanceof TileEntityRouter)) continue;
            this.foundRouter = (TileEntityRouter)te;
            return;
        }
    }

    @Override
    public boolean hasNext() {
        return this.foundRouter != null;
    }

    @Override
    public TileEntityRouter next() {
        TileEntityRouter f = this.foundRouter;
        this.findNext();
        return f;
    }
}

