/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.clientinfo;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mcjty.lib.network.NetworkTools;
import mcjty.xnet.XNet;
import mcjty.xnet.api.channels.IChannelType;
import mcjty.xnet.api.channels.IConnectorSettings;
import mcjty.xnet.api.keys.ConsumerId;
import mcjty.xnet.api.keys.SidedPos;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class ConnectorClientInfo {
    @Nonnull
    private final SidedPos pos;
    @Nonnull
    private final ConsumerId consumerId;
    @Nonnull
    private final IChannelType channelType;
    @Nonnull
    private final IConnectorSettings connectorSettings;
    private final boolean advanced;

    public ConnectorClientInfo(@Nonnull SidedPos pos, @Nonnull ConsumerId consumerId, @Nonnull IChannelType channelType, @Nonnull IConnectorSettings connectorSettings, boolean advanced) {
        this.pos = pos;
        this.consumerId = consumerId;
        this.channelType = channelType;
        this.connectorSettings = connectorSettings;
        this.advanced = advanced;
    }

    public ConnectorClientInfo(@Nonnull ByteBuf buf) {
        this.pos = new SidedPos(NetworkTools.readPos((ByteBuf)buf), EnumFacing.field_82609_l[buf.readByte()]);
        this.consumerId = new ConsumerId(buf.readInt());
        IChannelType t = XNet.xNetApi.findType(NetworkTools.readString((ByteBuf)buf));
        if (t == null) {
            throw new RuntimeException("Cannot happen!");
        }
        this.channelType = t;
        this.advanced = buf.readBoolean();
        NBTTagCompound tag = NetworkTools.readTag((ByteBuf)buf);
        this.connectorSettings = this.channelType.createConnector(this.advanced, this.pos.getSide());
        this.connectorSettings.readFromNBT(tag);
    }

    public void writeToBuf(@Nonnull ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos.getPos());
        buf.writeByte(this.pos.getSide().ordinal());
        buf.writeInt(this.consumerId.getId());
        NetworkTools.writeString((ByteBuf)buf, (String)this.channelType.getID());
        buf.writeBoolean(this.advanced);
        NBTTagCompound tag = new NBTTagCompound();
        this.connectorSettings.writeToNBT(tag);
        NetworkTools.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    @Nonnull
    public SidedPos getPos() {
        return this.pos;
    }

    @Nonnull
    public ConsumerId getConsumerId() {
        return this.consumerId;
    }

    @Nonnull
    public IConnectorSettings getConnectorSettings() {
        return this.connectorSettings;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }
}

