/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockPosTools;
import mcjty.typed.Type;
import mcjty.xnet.api.channels.IChannelType;
import mcjty.xnet.api.channels.IConnectorSettings;
import mcjty.xnet.api.keys.NetworkId;
import mcjty.xnet.api.keys.SidedConsumer;
import mcjty.xnet.blocks.router.GuiRouter;
import mcjty.xnet.blocks.router.LocalChannelId;
import mcjty.xnet.clientinfo.ControllerChannelClientInfo;
import mcjty.xnet.config.GeneralConfiguration;
import mcjty.xnet.logic.ChannelInfo;
import mcjty.xnet.logic.LogicTools;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.BlockPos;

public final class TileEntityRouter
extends GenericTileEntity {
    public static final String CMD_UPDATENAME = "updateName";
    public static final String CMD_GETCHANNELS = "getChannelInfo";
    public static final String CLIENTCMD_CHANNELSREADY = "channelsReady";
    public static final String CMD_GETREMOTECHANNELS = "getRemoteChannelInfo";
    public static final String CLIENTCMD_CHANNELSREMOTEREADY = "channelsRemoteReady";
    private Map<LocalChannelId, String> publishedChannels = new HashMap<LocalChannelId, String>();
    private int channelCount = 0;

    public void addPublishedChannels(Set<String> channels) {
        channels.addAll(this.publishedChannels.values());
    }

    public int countPublishedChannelsOnNet() {
        HashSet channels = new HashSet();
        NetworkId networkId = this.findRoutingNetwork();
        if (networkId != null) {
            LogicTools.routers(this.func_145831_w(), networkId).forEach(router -> router.addPublishedChannels(channels));
        }
        return channels.size();
    }

    public boolean inError() {
        return this.channelCount > GeneralConfiguration.maxPublishedChannels;
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public void setChannelCount(int cnt) {
        if (this.channelCount == cnt) {
            return;
        }
        this.channelCount = cnt;
        this.markDirtyClient();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean oldError = this.inError();
        super.onDataPacket(net, packet);
        if (this.func_145831_w().field_72995_K && oldError != this.inError()) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        return super.func_189515_b(tagCompound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("chancnt", this.channelCount);
        NBTTagList published = new NBTTagList();
        for (Map.Entry<LocalChannelId, String> entry : this.publishedChannels.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            BlockPosTools.writeToNBT((NBTTagCompound)tc, (String)"pos", (BlockPos)entry.getKey().getControllerPos());
            tc.func_74768_a("index", entry.getKey().getIndex());
            tc.func_74778_a("name", entry.getValue());
            published.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("published", (NBTBase)published);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.channelCount = tagCompound.func_74762_e("chancnt");
        NBTTagList published = tagCompound.func_150295_c("published", 10);
        for (int i = 0; i < published.func_74745_c(); ++i) {
            NBTTagCompound tc = published.func_150305_b(i);
            LocalChannelId id = new LocalChannelId(BlockPosTools.readFromNBT((NBTTagCompound)tc, (String)"pos"), tc.func_74762_e("index"));
            String name = tc.func_74779_i("name");
            this.publishedChannels.put(id, name);
        }
    }

    @Nonnull
    private List<ControllerChannelClientInfo> findLocalChannelInfo(boolean onlyPublished) {
        ArrayList<ControllerChannelClientInfo> list = new ArrayList<ControllerChannelClientInfo>();
        LogicTools.connectors(this.func_145831_w(), this.func_174877_v()).map(connectorPos -> LogicTools.getControllerForConnector(this.func_145831_w(), connectorPos)).filter(Objects::nonNull).forEach(controller -> {
            for (int i = 0; i < 8; ++i) {
                ChannelInfo channelInfo = controller.getChannels()[i];
                if (channelInfo == null || channelInfo.getChannelName().isEmpty()) continue;
                LocalChannelId id = new LocalChannelId(controller.func_174877_v(), i);
                String publishedName = this.publishedChannels.get(id);
                if (publishedName == null) {
                    publishedName = "";
                }
                if (onlyPublished && publishedName.isEmpty()) continue;
                ControllerChannelClientInfo ci = new ControllerChannelClientInfo(channelInfo.getChannelName(), publishedName, controller.func_174877_v(), channelInfo.getType(), i);
                list.add(ci);
            }
        });
        return list;
    }

    @Nonnull
    private List<ControllerChannelClientInfo> findRemoteChannelInfo() {
        ArrayList<ControllerChannelClientInfo> list = new ArrayList<ControllerChannelClientInfo>();
        NetworkId networkId = this.findRoutingNetwork();
        if (networkId != null) {
            LogicTools.consumers(this.func_145831_w(), networkId).forEach(consumerPos -> LogicTools.routers(this.func_145831_w(), consumerPos).filter(r -> r != this).forEach(router -> list.addAll(router.findLocalChannelInfo(true))));
        }
        return list;
    }

    @Nullable
    private NetworkId findRoutingNetwork() {
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        return LogicTools.routingConnectors(this.func_145831_w(), this.func_174877_v()).findFirst().map(worldBlob::getNetworkAt).orElse(null);
    }

    public void addRoutedConnectors(Map<SidedConsumer, IConnectorSettings> connectors, @Nonnull BlockPos controllerPos, int channel, IChannelType type) {
        if (this.inError()) {
            return;
        }
        LocalChannelId id = new LocalChannelId(controllerPos, channel);
        String publishedName = this.publishedChannels.get(id);
        if (publishedName != null && !publishedName.isEmpty()) {
            NetworkId networkId = this.findRoutingNetwork();
            if (networkId != null) {
                LogicTools.consumers(this.func_145831_w(), networkId).forEach(consumerPos -> LogicTools.routers(this.func_145831_w(), consumerPos).forEach(router -> router.addConnectorsFromConnectedNetworks(connectors, publishedName, type)));
            } else {
                this.addConnectorsFromConnectedNetworks(connectors, publishedName, type);
            }
        }
    }

    private void addConnectorsFromConnectedNetworks(Map<SidedConsumer, IConnectorSettings> connectors, String channelName, IChannelType type) {
        LogicTools.connectors(this.func_145831_w(), this.func_174877_v()).map(connectorPos -> LogicTools.getControllerForConnector(this.func_145831_w(), connectorPos)).filter(Objects::nonNull).forEach(controller -> {
            for (int i = 0; i < 8; ++i) {
                String publishedName;
                ChannelInfo info = controller.getChannels()[i];
                if (info == null || (publishedName = this.publishedChannels.get(new LocalChannelId(controller.func_174877_v(), i))) == null || publishedName.isEmpty() || !channelName.equals(publishedName) || !type.equals(info.getType())) continue;
                connectors.putAll(controller.getConnectors(i));
            }
        });
    }

    private void updatePublishName(@Nonnull BlockPos controllerPos, int channel, String name) {
        LocalChannelId id = new LocalChannelId(controllerPos, channel);
        if (name == null || name.isEmpty()) {
            this.publishedChannels.remove(id);
        } else {
            this.publishedChannels.put(id, name);
        }
        int number = this.countPublishedChannelsOnNet();
        NetworkId networkId = this.findRoutingNetwork();
        if (networkId != null) {
            if (number != this.channelCount) {
                LogicTools.routers(this.func_145831_w(), networkId).forEach(router -> router.setChannelCount(number));
            }
            WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
            worldBlob.incNetworkVersion(networkId);
        }
        this.markDirtyQuick();
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_UPDATENAME.equals(command)) {
            BlockPos controllerPos = args.get("pos").getCoordinate();
            int channel = args.get("channel").getInteger();
            String name = args.get("name").getString();
            this.updatePublishName(controllerPos, channel, name);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, Map<String, Argument> args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if (CMD_GETCHANNELS.equals(command)) {
            return type.convert(this.findLocalChannelInfo(false));
        }
        if (CMD_GETREMOTECHANNELS.equals(command)) {
            return type.convert(this.findRemoteChannelInfo());
        }
        return Collections.emptyList();
    }

    public <T> boolean execute(String command, List<T> list, Type<T> type) {
        boolean rc = super.execute(command, list, type);
        if (rc) {
            return true;
        }
        if (CLIENTCMD_CHANNELSREADY.equals(command)) {
            GuiRouter.fromServer_localChannels = new ArrayList<ControllerChannelClientInfo>(Type.create(ControllerChannelClientInfo.class).convert(list));
            return true;
        }
        if (CLIENTCMD_CHANNELSREMOTEREADY.equals(command)) {
            GuiRouter.fromServer_remoteChannels = new ArrayList<ControllerChannelClientInfo>(Type.create(ControllerChannelClientInfo.class).convert(list));
            return true;
        }
        return false;
    }
}

