/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.router;

import java.util.Set;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.xnet.api.keys.NetworkId;
import mcjty.xnet.blocks.generic.CableColor;
import mcjty.xnet.blocks.generic.GenericXNetBlock;
import mcjty.xnet.blocks.router.GuiRouter;
import mcjty.xnet.blocks.router.TileEntityRouter;
import mcjty.xnet.multiblock.BlobId;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RouterBlock
extends GenericXNetBlock<TileEntityRouter, EmptyContainer> {
    public static final PropertyBool ERROR = PropertyBool.func_177716_a((String)"error");

    public RouterBlock() {
        super(Material.field_151573_f, TileEntityRouter.class, EmptyContainer.class, "router", false);
    }

    public int getGuiID() {
        return 3;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Class<? extends GenericGuiContainer> getGuiClass() {
        return GuiRouter.class;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te;
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        XNetBlobData blobData = XNetBlobData.getBlobData(world);
        WorldBlob worldBlob = blobData.getWorldBlob(world);
        Set<NetworkId> networks = worldBlob.getNetworksAt(data.getPos());
        for (NetworkId networkId : networks) {
            probeInfo.text(TextStyleClass.LABEL + "Network: " + TextStyleClass.INFO + networkId.getId());
            if (mode == ProbeMode.EXTENDED) continue;
            break;
        }
        if ((te = world.func_175625_s(data.getPos())) instanceof TileEntityRouter) {
            TileEntityRouter router = (TileEntityRouter)te;
            if (router.inError()) {
                probeInfo.text(TextStyleClass.ERROR + "Too many channels on router!");
            } else {
                probeInfo.text(TextStyleClass.LABEL + "Channels: " + TextStyleClass.INFO + router.getChannelCount());
            }
        }
        if (mode == ProbeMode.DEBUG) {
            ColorId colorId;
            BlobId blobId = worldBlob.getBlobAt(data.getPos());
            if (blobId != null) {
                probeInfo.text(TextStyleClass.LABEL + "Blob: " + TextStyleClass.INFO + blobId.getId());
            }
            if ((colorId = worldBlob.getColorAt(data.getPos())) != null) {
                probeInfo.text(TextStyleClass.LABEL + "Color: " + TextStyleClass.INFO + colorId.getId());
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            XNetBlobData blobData = XNetBlobData.getBlobData(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            NetworkId networkId = worldBlob.newNetwork();
            worldBlob.createNetworkProvider(pos, new ColorId(CableColor.ROUTING.ordinal() + 1), networkId);
            blobData.save(world);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            XNetBlobData blobData = XNetBlobData.getBlobData(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            worldBlob.removeCableSegment(pos);
            blobData.save(world);
        }
        super.func_180663_b(world, pos, state);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        boolean error = false;
        if (te instanceof TileEntityRouter) {
            error = ((TileEntityRouter)te).inError();
        }
        return state.func_177226_a((IProperty)ERROR, (Comparable)Boolean.valueOf(error));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ERROR});
    }
}

