/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.cables;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.xnet.blocks.cables.ConnectorBlock;
import mcjty.xnet.blocks.cables.ConnectorType;
import mcjty.xnet.blocks.generic.CableColor;
import mcjty.xnet.blocks.generic.GenericCableBakedModel;
import mcjty.xnet.blocks.generic.GenericCableBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetCableBlock
extends GenericCableBlock {
    public static final String NETCABLE = "netcable";

    public NetCableBlock() {
        super(Material.field_151580_n, NETCABLE);
    }

    public NetCableBlock(Material material, String name) {
        super(material, name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        StateMapperBase ignoreState = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState iBlockState) {
                return GenericCableBakedModel.modelCable;
            }
        };
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)ignoreState);
    }

    protected void clGetSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (CableColor value : CableColor.VALUES) {
            subItems.add(this.updateColorInStack(new ItemStack(itemIn, 1, value.ordinal()), value));
        }
    }

    protected IBlockState clGetStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getPlacementState(world, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    public IBlockState getPlacementState(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        world.func_175704_b(pos.func_177982_a(-1, -1, -1), pos.func_177982_a(1, 1, 1));
        return super.clGetStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    @Override
    protected ConnectorType getConnectorType(@Nonnull CableColor color, IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if ((block instanceof NetCableBlock || block instanceof ConnectorBlock) && state.func_177229_b((IProperty)COLOR) == color) {
            return ConnectorType.CABLE;
        }
        return ConnectorType.NONE;
    }
}

