/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.logic;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.tools.FluidTools;
import mcjty.lib.tools.ItemStackTools;
import mcjty.xnet.api.channels.Color;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.apiimpl.energy.EnergyChannelSettings;
import mcjty.xnet.apiimpl.fluids.FluidChannelSettings;
import mcjty.xnet.apiimpl.items.ItemChannelSettings;
import mcjty.xnet.apiimpl.logic.LogicConnectorSettings;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;

class Sensor {
    public static final String TAG_MODE = "mode";
    public static final String TAG_OPERATOR = "op";
    public static final String TAG_AMOUNT = "amount";
    public static final String TAG_COLOR = "scolor";
    public static final String TAG_STACK = "stack";
    private final int index;
    private SensorMode sensorMode = SensorMode.OFF;
    private Operator operator = Operator.EQUAL;
    private int amount = 0;
    private Color outputColor = Color.OFF;
    private ItemStack filter = ItemStackTools.getEmptyStack();

    public Sensor(int index) {
        this.index = index;
    }

    public SensorMode getSensorMode() {
        return this.sensorMode;
    }

    public void setSensorMode(SensorMode sensorMode) {
        this.sensorMode = sensorMode;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public Color getOutputColor() {
        return this.outputColor;
    }

    public void setOutputColor(Color outputColor) {
        this.outputColor = outputColor;
    }

    public boolean isEnabled(String tag) {
        if ((TAG_MODE + this.index).equals(tag)) {
            return true;
        }
        if ((TAG_OPERATOR + this.index).equals(tag)) {
            return true;
        }
        if ((TAG_AMOUNT + this.index).equals(tag)) {
            return true;
        }
        if ((TAG_COLOR + this.index).equals(tag)) {
            return true;
        }
        if ((TAG_STACK + this.index).equals(tag)) {
            return this.sensorMode == SensorMode.FLUID || this.sensorMode == SensorMode.ITEM;
        }
        return false;
    }

    public void createGui(IEditorGui gui) {
        gui.choices(TAG_MODE + this.index, "Sensor mode", this.sensorMode, SensorMode.values()).choices(TAG_OPERATOR + this.index, "Operator", this.operator, Operator.values()).integer(TAG_AMOUNT + this.index, "Amount to compare with", this.amount, 46).colors(TAG_COLOR + this.index, "Output color", this.outputColor.getColor(), Color.COLORS).ghostSlot(TAG_STACK + this.index, this.filter).nl();
    }

    public boolean test(@Nullable TileEntity te, @Nonnull World world, @Nonnull BlockPos pos, LogicConnectorSettings settings) {
        switch (this.sensorMode) {
            case ITEM: {
                IItemHandler handler = ItemChannelSettings.getItemHandlerAt(te, settings.getFacing());
                if (handler == null) break;
                int cnt = this.countItem(handler, this.filter, this.amount + 1);
                return this.operator.match(cnt, this.amount);
            }
            case FLUID: {
                IFluidHandler handler = FluidChannelSettings.getFluidHandlerAt(te, settings.getFacing());
                if (handler == null) break;
                int cnt = this.countFluid(handler, this.filter, this.amount + 1);
                return this.operator.match(cnt, this.amount);
            }
            case ENERGY: {
                if (!EnergyChannelSettings.isEnergyTE(te, settings.getFacing())) break;
                int cnt = EnergyChannelSettings.getEnergyLevel(te, settings.getFacing());
                return this.operator.match(cnt, this.amount);
            }
            case RS: {
                int cnt = world.func_175651_c(pos, settings.getFacing());
                return this.operator.match(cnt, this.amount);
            }
        }
        return false;
    }

    private int safeInt(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    public void update(Map<String, Object> data) {
        this.sensorMode = SensorMode.valueOf(((String)data.get(TAG_MODE + this.index)).toUpperCase());
        this.operator = Operator.valueOfCode(((String)data.get(TAG_OPERATOR + this.index)).toUpperCase());
        this.amount = this.safeInt(data.get(TAG_AMOUNT + this.index));
        this.outputColor = Color.colorByValue((Integer)data.get(TAG_COLOR + this.index));
        this.filter = (ItemStack)data.get(TAG_STACK + this.index);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.sensorMode = SensorMode.values()[tag.func_74771_c("sensorMode" + this.index)];
        this.operator = Operator.values()[tag.func_74771_c("operator" + this.index)];
        this.amount = tag.func_74762_e(TAG_AMOUNT + this.index);
        this.outputColor = Color.values()[tag.func_74771_c(TAG_COLOR + this.index)];
        if (tag.func_74764_b("filter" + this.index)) {
            NBTTagCompound itemTag = tag.func_74775_l("filter" + this.index);
            this.filter = ItemStackTools.loadFromNBT((NBTTagCompound)itemTag);
        } else {
            this.filter = ItemStackTools.getEmptyStack();
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74774_a("sensorMode" + this.index, (byte)this.sensorMode.ordinal());
        tag.func_74774_a("operator" + this.index, (byte)this.operator.ordinal());
        tag.func_74768_a(TAG_AMOUNT + this.index, this.amount);
        tag.func_74774_a(TAG_COLOR + this.index, (byte)this.outputColor.ordinal());
        if (ItemStackTools.isValid((ItemStack)this.filter)) {
            NBTTagCompound itemTag = new NBTTagCompound();
            this.filter.func_77955_b(itemTag);
            tag.func_74782_a("filter" + this.index, (NBTBase)itemTag);
        }
    }

    private int countItem(@Nonnull IItemHandler handler, ItemStack matcher, int maxNeeded) {
        int cnt = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!ItemStackTools.isValid((ItemStack)stack) || !(ItemStackTools.isValid((ItemStack)matcher) ? matcher.func_77969_a(stack) && (cnt += ItemStackTools.getStackSize((ItemStack)stack)) >= maxNeeded : (cnt += ItemStackTools.getStackSize((ItemStack)stack)) >= maxNeeded)) continue;
            return cnt;
        }
        return cnt;
    }

    private int countFluid(@Nonnull IFluidHandler handler, ItemStack matcher, int maxNeeded) {
        FluidStack fluidStack = ItemStackTools.isValid((ItemStack)matcher) ? FluidTools.convertBucketToFluid((ItemStack)matcher) : null;
        IFluidTankProperties[] properties = handler.getTankProperties();
        int cnt = 0;
        for (IFluidTankProperties property : properties) {
            FluidStack contents = property.getContents();
            if (contents == null || !(fluidStack != null ? fluidStack.isFluidEqual(contents) && (cnt += contents.amount) >= maxNeeded : (cnt += contents.amount) >= maxNeeded)) continue;
            return cnt;
        }
        return cnt;
    }

    static enum Operator {
        EQUAL("=", (i1, i2) -> i1 == i2),
        NOTEQUAL("!=", (i1, i2) -> i1 != i2),
        LESS("<", (i1, i2) -> i1 < i2),
        GREATER(">", (i1, i2) -> i1 > i2),
        LESSOREQUAL("<=", (i1, i2) -> i1 <= i2),
        GREATOROREQUAL(">=", (i1, i2) -> i1 >= i2);

        private final String code;
        private final BiPredicate<Integer, Integer> matcher;
        private static final Map<String, Operator> OPERATOR_MAP;

        private Operator(String code, BiPredicate<Integer, Integer> matcher) {
            this.code = code;
            this.matcher = matcher;
        }

        public String getCode() {
            return this.code;
        }

        public boolean match(int i1, int i2) {
            return this.matcher.test(i1, i2);
        }

        public String toString() {
            return this.code;
        }

        public static Operator valueOfCode(String code) {
            return OPERATOR_MAP.get(code);
        }

        static {
            OPERATOR_MAP = new HashMap<String, Operator>();
            for (Operator operator : Operator.values()) {
                OPERATOR_MAP.put(operator.code, operator);
            }
        }
    }

    static enum SensorMode {
        OFF,
        ITEM,
        FLUID,
        ENERGY,
        RS;

    }
}

