/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.logic;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.apiimpl.AbstractConnectorSettings;
import mcjty.xnet.apiimpl.logic.Sensor;
import mcjty.xnet.blocks.controller.gui.GuiController;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class LogicConnectorSettings
extends AbstractConnectorSettings {
    public static final String TAG_SPEED = "speed";
    public static final int SENSORS = 4;
    private List<Sensor> sensors = new ArrayList<Sensor>(4);
    private int colors;
    private int speed = 2;
    private static Set<String> TAGS = ImmutableSet.of((Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3");

    public LogicConnectorSettings(boolean advanced, @Nonnull EnumFacing side) {
        super(advanced, side);
        for (int i = 0; i < 4; ++i) {
            this.sensors.add(new Sensor(i));
        }
    }

    public List<Sensor> getSensors() {
        return this.sensors;
    }

    public void setColorMask(int colors) {
        this.colors = colors;
    }

    public int getColorMask() {
        return this.colors;
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(GuiController.iconGuiElements, 26, 70, 13, 10);
    }

    @Override
    @Nullable
    public String getIndicator() {
        return null;
    }

    @Override
    public boolean isEnabled(String tag) {
        if (tag.equals("facing")) {
            return this.isAdvanced();
        }
        if (tag.equals(TAG_SPEED)) {
            return true;
        }
        for (Sensor sensor : this.sensors) {
            if (!sensor.isEnabled(tag)) continue;
            return true;
        }
        return TAGS.contains(tag);
    }

    public int getSpeed() {
        return this.speed;
    }

    @Override
    public void createGui(IEditorGui gui) {
        String[] speeds = this.isAdvanced() ? new String[]{"10", "20", "60", "100", "200"} : new String[]{"20", "60", "100", "200"};
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().choices(TAG_SPEED, "Number of ticks for each check", Integer.toString(this.speed * 10), speeds).nl();
        for (Sensor sensor : this.sensors) {
            sensor.createGui(gui);
        }
    }

    @Override
    public void update(Map<String, Object> data) {
        super.update(data);
        String facing = (String)data.get("facing");
        this.speed = Integer.parseInt((String)data.get(TAG_SPEED)) / 10;
        if (this.speed == 0) {
            this.speed = 2;
        }
        for (Sensor sensor : this.sensors) {
            sensor.update(data);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.speed = tag.func_74762_e(TAG_SPEED);
        if (this.speed == 0) {
            this.speed = 2;
        }
        this.colors = tag.func_74762_e("colors");
        for (Sensor sensor : this.sensors) {
            sensor.readFromNBT(tag);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a(TAG_SPEED, this.speed);
        tag.func_74768_a("colors", this.colors);
        for (Sensor sensor : this.sensors) {
            sensor.writeToNBT(tag);
        }
    }
}

