/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.items;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.tools.ItemStackList;
import mcjty.lib.tools.ItemStackTools;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.apiimpl.AbstractConnectorSettings;
import mcjty.xnet.apiimpl.items.ItemFilterCache;
import mcjty.xnet.blocks.controller.gui.GuiController;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class ItemConnectorSettings
extends AbstractConnectorSettings {
    public static final String TAG_MODE = "mode";
    public static final String TAG_STACK = "stack";
    public static final String TAG_SPEED = "speed";
    public static final String TAG_OREDICT = "od";
    public static final String TAG_NBT = "nbt";
    public static final String TAG_META = "meta";
    public static final String TAG_PRIORITY = "priority";
    public static final String TAG_COUNT = "count";
    public static final String TAG_FILTER = "flt";
    public static final String TAG_BLACKLIST = "blacklist";
    public static final int FILTER_SIZE = 18;
    private ItemMode itemMode = ItemMode.INS;
    private int speed = 2;
    private StackMode stackMode = StackMode.SINGLE;
    private boolean oredictMode = false;
    private boolean metaMode = false;
    private boolean nbtMode = false;
    private boolean blacklist = false;
    @Nullable
    private Integer priority = 0;
    @Nullable
    private Integer count = null;
    private ItemStackList filters = ItemStackList.create((int)18);
    private Predicate<ItemStack> matcher = null;
    private static Set<String> INSERT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"count", "priority", "od", "meta", "nbt", "blacklist"});
    private static Set<String> EXTRACT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"count", "od", "meta", "nbt", "blacklist", "stack", "speed"});

    public ItemMode getItemMode() {
        return this.itemMode;
    }

    public ItemConnectorSettings(boolean advanced, @Nonnull EnumFacing side) {
        super(advanced, side);
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        switch (this.itemMode) {
            case INS: {
                return new IndicatorIcon(GuiController.iconGuiElements, 0, 70, 13, 10);
            }
            case EXT: {
                return new IndicatorIcon(GuiController.iconGuiElements, 13, 70, 13, 10);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getIndicator() {
        return null;
    }

    @Override
    public void createGui(IEditorGui gui) {
        String[] speeds = this.isAdvanced() ? new String[]{"10", "20", "60", "100", "200"} : new String[]{"20", "60", "100", "200"};
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().choices(TAG_MODE, "Insert or extract mode", this.itemMode, ItemMode.values()).choices(TAG_STACK, "Single item or entire stack", this.stackMode, StackMode.values()).choices(TAG_SPEED, "Number of ticks for each operation", Integer.toString(this.speed * 10), speeds).nl().label("Pri").integer(TAG_PRIORITY, "Insertion priority", this.priority, 36).shift(5).label("#").integer(TAG_COUNT, this.itemMode == ItemMode.EXT ? "Amount in destination inventory|to keep" : "Max amount in destination|inventory", this.count, 36).nl().toggleText(TAG_BLACKLIST, "Enable blacklist mode", "BL", this.blacklist).shift(2).toggleText(TAG_OREDICT, "Ore dictionary matching", "Ore", this.oredictMode).shift(2).toggleText(TAG_META, "Metadata matching", "Meta", this.metaMode).shift(2).toggleText(TAG_NBT, "NBT matching", "NBT", this.nbtMode).nl();
        for (int i = 0; i < 18; ++i) {
            gui.ghostSlot(TAG_FILTER + i, (ItemStack)this.filters.get(i));
        }
    }

    public Predicate<ItemStack> getMatcher() {
        if (this.matcher == null) {
            ItemStackList filterList = ItemStackList.create();
            for (ItemStack stack : this.filters) {
                if (!ItemStackTools.isValid((ItemStack)stack)) continue;
                filterList.add((Object)stack);
            }
            if (filterList.isEmpty()) {
                this.matcher = itemStack -> true;
            } else {
                ItemFilterCache filterCache = new ItemFilterCache(this.metaMode, this.oredictMode, this.blacklist, this.nbtMode, filterList);
                this.matcher = filterCache::match;
            }
        }
        return this.matcher;
    }

    public StackMode getStackMode() {
        return this.stackMode;
    }

    @Nonnull
    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Nullable
    public Integer getCount() {
        return this.count;
    }

    public int getSpeed() {
        return this.speed;
    }

    @Override
    public boolean isEnabled(String tag) {
        if (tag.startsWith(TAG_FILTER)) {
            return true;
        }
        if (tag.equals("facing")) {
            return this.isAdvanced();
        }
        if (this.itemMode == ItemMode.INS) {
            return INSERT_TAGS.contains(tag);
        }
        return EXTRACT_TAGS.contains(tag);
    }

    @Override
    public void update(Map<String, Object> data) {
        super.update(data);
        this.itemMode = ItemMode.valueOf(((String)data.get(TAG_MODE)).toUpperCase());
        this.stackMode = StackMode.valueOf(((String)data.get(TAG_STACK)).toUpperCase());
        this.speed = Integer.parseInt((String)data.get(TAG_SPEED)) / 10;
        if (this.speed == 0) {
            this.speed = 2;
        }
        this.oredictMode = Boolean.TRUE.equals(data.get(TAG_OREDICT));
        this.metaMode = Boolean.TRUE.equals(data.get(TAG_META));
        this.nbtMode = Boolean.TRUE.equals(data.get(TAG_NBT));
        this.blacklist = Boolean.TRUE.equals(data.get(TAG_BLACKLIST));
        this.priority = (Integer)data.get(TAG_PRIORITY);
        this.count = (Integer)data.get(TAG_COUNT);
        for (int i = 0; i < 18; ++i) {
            this.filters.set(i, (Object)((ItemStack)data.get(TAG_FILTER + i)));
        }
        this.matcher = null;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.itemMode = ItemMode.values()[tag.func_74771_c("itemMode")];
        this.stackMode = StackMode.values()[tag.func_74771_c("stackMode")];
        this.speed = tag.func_74762_e(TAG_SPEED);
        if (this.speed == 0) {
            this.speed = 2;
        }
        this.oredictMode = tag.func_74767_n("oredictMode");
        this.metaMode = tag.func_74767_n("metaMode");
        this.nbtMode = tag.func_74767_n("nbtMode");
        this.blacklist = tag.func_74767_n(TAG_BLACKLIST);
        this.priority = tag.func_74764_b(TAG_PRIORITY) ? Integer.valueOf(tag.func_74762_e(TAG_PRIORITY)) : null;
        this.count = tag.func_74764_b(TAG_COUNT) ? Integer.valueOf(tag.func_74762_e(TAG_COUNT)) : null;
        for (int i = 0; i < 18; ++i) {
            if (tag.func_74764_b("filter" + i)) {
                NBTTagCompound itemTag = tag.func_74775_l("filter" + i);
                this.filters.set(i, (Object)ItemStackTools.loadFromNBT((NBTTagCompound)itemTag));
                continue;
            }
            this.filters.set(i, (Object)ItemStackTools.getEmptyStack());
        }
        this.matcher = null;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("itemMode", (byte)this.itemMode.ordinal());
        tag.func_74774_a("stackMode", (byte)this.stackMode.ordinal());
        tag.func_74768_a(TAG_SPEED, this.speed);
        tag.func_74757_a("oredictMode", this.oredictMode);
        tag.func_74757_a("metaMode", this.metaMode);
        tag.func_74757_a("nbtMode", this.nbtMode);
        tag.func_74757_a(TAG_BLACKLIST, this.blacklist);
        if (this.priority != null) {
            tag.func_74768_a(TAG_PRIORITY, this.priority.intValue());
        }
        if (this.count != null) {
            tag.func_74768_a(TAG_COUNT, this.count.intValue());
        }
        for (int i = 0; i < 18; ++i) {
            if (!ItemStackTools.isValid((ItemStack)((ItemStack)this.filters.get(i)))) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            ((ItemStack)this.filters.get(i)).func_77955_b(itemTag);
            tag.func_74782_a("filter" + i, (NBTBase)itemTag);
        }
    }

    static enum StackMode {
        SINGLE,
        STACK;

    }

    static enum ItemMode {
        INS,
        EXT;

    }
}

