/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.varia.WorldTools;
import mcjty.xnet.api.channels.IChannelSettings;
import mcjty.xnet.api.channels.IConnectorSettings;
import mcjty.xnet.api.channels.IControllerContext;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.keys.SidedConsumer;
import mcjty.xnet.apiimpl.DefaultChannelSettings;
import mcjty.xnet.apiimpl.items.ItemConnectorSettings;
import mcjty.xnet.blocks.controller.gui.GuiController;
import mcjty.xnet.config.GeneralConfiguration;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class ItemChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    public static final String TAG_MODE = "mode";
    private Map<SidedConsumer, ItemConnectorSettings> itemExtractors = null;
    private List<Pair<SidedConsumer, ItemConnectorSettings>> itemConsumers = null;
    private ChannelMode channelMode = ChannelMode.PRIORITY;
    private int delay = 0;
    private int roundRobinOffset = 0;

    public ChannelMode getChannelMode() {
        return this.channelMode;
    }

    @Override
    public int getColors() {
        return 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.channelMode = ChannelMode.values()[tag.func_74771_c(TAG_MODE)];
        this.delay = tag.func_74762_e("delay");
        this.roundRobinOffset = tag.func_74762_e("offset");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74774_a(TAG_MODE, (byte)this.channelMode.ordinal());
        tag.func_74768_a("delay", this.delay);
        tag.func_74768_a("offset", this.roundRobinOffset);
    }

    @Override
    public void tick(int channel, IControllerContext context) {
        --this.delay;
        if (this.delay <= 0) {
            this.delay = 1200;
        }
        if (this.delay % 10 != 0) {
            return;
        }
        int d = this.delay / 10;
        this.updateCache(channel, context);
        World world = context.getControllerWorld();
        block0: for (Map.Entry<SidedConsumer, ItemConnectorSettings> entry : this.itemExtractors.entrySet()) {
            ItemStack stack;
            TileEntity te;
            IItemHandler handler;
            EnumFacing side;
            BlockPos pos;
            BlockPos extractorPos;
            ItemConnectorSettings settings = entry.getValue();
            if (d % settings.getSpeed() != 0 || (extractorPos = context.findConsumerPosition(entry.getKey().getConsumerId())) == null || !WorldTools.chunkLoaded((World)world, (BlockPos)(pos = extractorPos.func_177972_a(side = entry.getKey().getSide()))) || (handler = ItemChannelSettings.getItemHandlerAt(te = world.func_175625_s(pos), settings.getFacing())) == null || this.checkRedstone(world, settings, extractorPos) || !context.matchColor(settings.getColorsMask())) continue;
            Predicate<ItemStack> extractMatcher = settings.getMatcher();
            Integer count = settings.getCount();
            int amount = 0;
            if (count != null && (amount = this.countItems(handler, extractMatcher)) < count) continue;
            MInteger index = new MInteger(0);
            while (ItemStackTools.isValid((ItemStack)(stack = this.fetchItem(handler, true, extractMatcher, settings.getStackMode(), 64, index)))) {
                int toextract = ItemStackTools.getStackSize((ItemStack)stack);
                if (count != null) {
                    int canextract = amount - count;
                    if (canextract <= 0) {
                        index.inc();
                        continue;
                    }
                    if (canextract < toextract) {
                        toextract = canextract;
                        ItemStackTools.setStackSize((ItemStack)stack, (int)toextract);
                    }
                }
                ArrayList<Pair<SidedConsumer, ItemConnectorSettings>> inserted = new ArrayList<Pair<SidedConsumer, ItemConnectorSettings>>();
                int remaining = this.insertStackSimulate(inserted, context, stack);
                if (!inserted.isEmpty()) {
                    if (!context.checkAndConsumeRF(GeneralConfiguration.controllerOperationRFT)) continue block0;
                    this.insertStackReal(context, inserted, this.fetchItem(handler, false, extractMatcher, settings.getStackMode(), toextract - remaining, index));
                    continue block0;
                }
                index.inc();
            }
        }
    }

    private int insertStackSimulate(@Nonnull List<Pair<SidedConsumer, ItemConnectorSettings>> inserted, @Nonnull IControllerContext context, @Nonnull ItemStack stack) {
        World world = context.getControllerWorld();
        if (this.channelMode == ChannelMode.PRIORITY) {
            this.roundRobinOffset = 0;
        }
        int total = ItemStackTools.getStackSize((ItemStack)stack);
        for (int j = 0; j < this.itemConsumers.size(); ++j) {
            EnumFacing side;
            BlockPos pos;
            TileEntity te;
            IItemHandler handler;
            BlockPos consumerPos;
            int i = (j + this.roundRobinOffset) % this.itemConsumers.size();
            Pair<SidedConsumer, ItemConnectorSettings> entry = this.itemConsumers.get(i);
            ItemConnectorSettings settings = (ItemConnectorSettings)entry.getValue();
            if (!settings.getMatcher().test(stack) || (consumerPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).getConsumerId())) == null || !WorldTools.chunkLoaded((World)world, (BlockPos)consumerPos) || this.checkRedstone(world, settings, consumerPos) || !context.matchColor(settings.getColorsMask()) || (handler = ItemChannelSettings.getItemHandlerAt(te = world.func_175625_s(pos = consumerPos.func_177972_a(side = ((SidedConsumer)entry.getKey()).getSide())), settings.getFacing())) == null) continue;
            int toinsert = total;
            Integer count = settings.getCount();
            if (count != null) {
                int amount = this.countItems(handler, settings.getMatcher());
                int caninsert = count - amount;
                if (caninsert <= 0) continue;
                toinsert = Math.min(toinsert, caninsert);
                ItemStackTools.setStackSize((ItemStack)stack, (int)toinsert);
            }
            ItemStack remaining = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true);
            int actuallyinserted = toinsert - ItemStackTools.getStackSize((ItemStack)remaining);
            if (count == null) {
                stack = remaining;
            }
            if (actuallyinserted <= 0) continue;
            inserted.add(entry);
            if ((total -= actuallyinserted) > 0) continue;
            return 0;
        }
        return total;
    }

    private void insertStackReal(@Nonnull IControllerContext context, @Nonnull List<Pair<SidedConsumer, ItemConnectorSettings>> inserted, @Nonnull ItemStack stack) {
        int total = ItemStackTools.getStackSize((ItemStack)stack);
        for (Pair<SidedConsumer, ItemConnectorSettings> entry : inserted) {
            BlockPos consumerPosition = context.findConsumerPosition(((SidedConsumer)entry.getKey()).getConsumerId());
            EnumFacing side = ((SidedConsumer)entry.getKey()).getSide();
            ItemConnectorSettings settings = (ItemConnectorSettings)entry.getValue();
            BlockPos pos = consumerPosition.func_177972_a(side);
            TileEntity te = context.getControllerWorld().func_175625_s(pos);
            IItemHandler handler = ItemChannelSettings.getItemHandlerAt(te, settings.getFacing());
            int toinsert = total;
            Integer count = settings.getCount();
            if (count != null) {
                int amount = this.countItems(handler, settings.getMatcher());
                int caninsert = count - amount;
                if (caninsert <= 0) continue;
                toinsert = Math.min(toinsert, caninsert);
                ItemStackTools.setStackSize((ItemStack)stack, (int)toinsert);
            }
            ItemStack remaining = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
            int actuallyinserted = toinsert - ItemStackTools.getStackSize((ItemStack)remaining);
            if (count == null) {
                stack = remaining;
            }
            if (actuallyinserted <= 0) continue;
            this.roundRobinOffset = (this.roundRobinOffset + 1) % this.itemConsumers.size();
            if ((total -= actuallyinserted) > 0) continue;
            return;
        }
    }

    private int countItems(IItemHandler handler, Predicate<ItemStack> matcher) {
        int cnt = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack s = handler.getStackInSlot(i);
            if (!ItemStackTools.isValid((ItemStack)s) || !matcher.test(s)) continue;
            cnt += ItemStackTools.getStackSize((ItemStack)s);
        }
        return cnt;
    }

    private ItemStack fetchItem(IItemHandler handler, boolean simulate, Predicate<ItemStack> matcher, ItemConnectorSettings.StackMode stackMode, int maxamount, MInteger index) {
        for (int i = index.get(); i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!ItemStackTools.isValid((ItemStack)stack)) continue;
            int s = stackMode == ItemConnectorSettings.StackMode.SINGLE ? 1 : stack.func_77976_d();
            stack = handler.extractItem(i, s = Math.min(s, maxamount), simulate);
            if (!ItemStackTools.isValid((ItemStack)stack) || !matcher.test(stack)) continue;
            index.set(i);
            return stack;
        }
        return ItemStackTools.getEmptyStack();
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.itemExtractors == null) {
            ItemConnectorSettings con;
            this.itemExtractors = new HashMap<SidedConsumer, ItemConnectorSettings>();
            this.itemConsumers = new ArrayList<Pair<SidedConsumer, ItemConnectorSettings>>();
            Map<SidedConsumer, IConnectorSettings> connectors = context.getConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (ItemConnectorSettings)entry.getValue();
                if (con.getItemMode() == ItemConnectorSettings.ItemMode.EXT) {
                    this.itemExtractors.put(entry.getKey(), con);
                    continue;
                }
                this.itemConsumers.add((Pair<SidedConsumer, ItemConnectorSettings>)Pair.of((Object)entry.getKey(), (Object)con));
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (ItemConnectorSettings)entry.getValue();
                if (con.getItemMode() != ItemConnectorSettings.ItemMode.INS) continue;
                this.itemConsumers.add((Pair<SidedConsumer, ItemConnectorSettings>)Pair.of((Object)entry.getKey(), (Object)con));
            }
            this.itemConsumers.sort((o1, o2) -> ((ItemConnectorSettings)o2.getRight()).getPriority().compareTo(((ItemConnectorSettings)o1.getRight()).getPriority()));
        }
    }

    @Override
    public void cleanCache() {
        this.itemExtractors = null;
        this.itemConsumers = null;
    }

    @Override
    public boolean isEnabled(String tag) {
        return true;
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(GuiController.iconGuiElements, 0, 80, 11, 10);
    }

    @Override
    @Nullable
    public String getIndicator() {
        return null;
    }

    @Override
    public void createGui(IEditorGui gui) {
        gui.nl().choices(TAG_MODE, "Item distribution mode", this.channelMode, ChannelMode.values());
    }

    @Override
    public void update(Map<String, Object> data) {
        this.channelMode = ChannelMode.valueOf(((String)data.get(TAG_MODE)).toUpperCase());
        this.roundRobinOffset = 0;
    }

    @Nullable
    public static IItemHandler getItemHandlerAt(@Nullable TileEntity te, EnumFacing intSide) {
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, intSide)) {
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, intSide);
            if (handler != null) {
                return handler;
            }
        } else {
            if (te instanceof ISidedInventory) {
                ISidedInventory sidedInventory = (ISidedInventory)te;
                return new SidedInvWrapper(sidedInventory, intSide);
            }
            if (te instanceof IInventory) {
                IInventory inventory = (IInventory)te;
                return new InvWrapper(inventory);
            }
        }
        return null;
    }

    private static class MInteger {
        private int i;

        public MInteger(int i) {
            this.i = i;
        }

        public int get() {
            return this.i;
        }

        public void set(int i) {
            this.i = i;
        }

        public void inc() {
            ++this.i;
        }
    }

    static enum ChannelMode {
        PRIORITY,
        ROUNDROBIN;

    }
}

