/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.api.channels;

import java.util.HashMap;
import java.util.Map;

public enum Color {
    OFF(0),
    WHITE(0xFFFFFF),
    RED(0xFF0000),
    GREEN(65280),
    BLUE(255),
    YELLOW(0xFFFF00),
    CYAN(65535),
    PURPLE(0xFF00FF);

    private final int color;
    private static final Map<Integer, Color> COLOR_MAP;
    public static final Integer[] COLORS;

    private Color(int color) {
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public static Color colorByValue(int color) {
        return COLOR_MAP.get(color);
    }

    static {
        COLOR_MAP = new HashMap<Integer, Color>();
        COLORS = new Integer[Color.values().length];
        for (int i = 0; i < Color.values().length; ++i) {
            Color col = Color.values()[i];
            Color.COLORS[i] = col.color;
            COLOR_MAP.put(col.color, col);
        }
    }
}

