/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.util.ResourceLocation;
import p455w0rdslib.util.ReflectionUtils;

public class PlayerTextureUtils {
    private static final MethodHandle GET_PLAYER_INFO = ReflectionUtils.findMethod(AbstractClientPlayer.class, new String[]{"getPlayerInfo", "func_175155_b"}, new Class[0]);
    private static final MethodHandle GET_PLAYER_TEXTURES = ReflectionUtils.findFieldGetter(NetworkPlayerInfo.class, "playerTextures", "field_187107_a");

    private static NetworkPlayerInfo getPlayerInfo(AbstractClientPlayer player) {
        try {
            return GET_PLAYER_INFO.invoke(player);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Map<MinecraftProfileTexture.Type, ResourceLocation> getPlayerTextures(AbstractClientPlayer player) {
        try {
            return GET_PLAYER_TEXTURES.invoke(PlayerTextureUtils.getPlayerInfo(player));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ResourceLocation getCape(AbstractClientPlayer player) {
        return PlayerTextureUtils.getPlayerTextures(player).get(MinecraftProfileTexture.Type.CAPE);
    }

    public static ResourceLocation getElytra(AbstractClientPlayer player) {
        return PlayerTextureUtils.getPlayerTextures(player).get(MinecraftProfileTexture.Type.ELYTRA);
    }

    public static ResourceLocation getSkin(AbstractClientPlayer player) {
        return PlayerTextureUtils.getPlayerTextures(player).get(MinecraftProfileTexture.Type.SKIN);
    }

    public static void setCape(AbstractClientPlayer player, ResourceLocation texture) {
        PlayerTextureUtils.getPlayerTextures(player).put(MinecraftProfileTexture.Type.CAPE, texture);
    }

    public static void setElytra(AbstractClientPlayer player, ResourceLocation texture) {
        PlayerTextureUtils.getPlayerTextures(player).put(MinecraftProfileTexture.Type.ELYTRA, texture);
    }

    public static void setSkin(AbstractClientPlayer player, ResourceLocation texture) {
        PlayerTextureUtils.getPlayerTextures(player).put(MinecraftProfileTexture.Type.SKIN, texture);
    }

    public static boolean hasCape(AbstractClientPlayer player) {
        return PlayerTextureUtils.getCape(player) != null;
    }

    public static boolean hasElytra(AbstractClientPlayer player) {
        return PlayerTextureUtils.getElytra(player) != null;
    }

    public static boolean hasSkin(AbstractClientPlayer player) {
        return PlayerTextureUtils.getSkin(player) != null;
    }
}

