/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import p455w0rdslib.P455w0rdsLib;
import p455w0rdslib.util.ItemUtils;

public class InventoryUtils {
    @SideOnly(value=Side.CLIENT)
    public static ItemStack getArmorPiece(EntityEquipmentSlot slot) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            EntityPlayer player = P455w0rdsLib.PROXY.getPlayer();
            ItemStack[] armorStack = player.field_71071_by.field_70460_b;
            int slotNum = 0;
            switch (slot) {
                case HEAD: {
                    slotNum = 3;
                    break;
                }
                case CHEST: {
                    slotNum = 2;
                    break;
                }
                case LEGS: {
                    slotNum = 1;
                    break;
                }
                default: {
                    slotNum = 0;
                }
            }
            return armorStack[slotNum];
        }
        return null;
    }

    public static boolean isInHotbar(int index) {
        return index >= 0 && index <= 8;
    }

    public static boolean isInInventory(int index) {
        return index >= 9 && index <= 36;
    }

    public static boolean moveStackWithinInventory(ItemStack itemStackIn, int index, List<Slot> inventorySlots) {
        block3: {
            block2: {
                if (!InventoryUtils.isInHotbar(index)) break block2;
                for (int i = 9; i <= 36; ++i) {
                    Slot possiblyOpenSlot = inventorySlots.get(i);
                    if (possiblyOpenSlot.func_75216_d()) continue;
                    possiblyOpenSlot.func_75215_d(itemStackIn);
                    inventorySlots.get(index).func_75215_d(null);
                    return true;
                }
                break block3;
            }
            if (!InventoryUtils.isInInventory(index)) break block3;
            for (int i = 0; i <= 8; ++i) {
                Slot possiblyOpenSlot = inventorySlots.get(i);
                if (possiblyOpenSlot.func_75216_d()) continue;
                possiblyOpenSlot.func_75215_d(itemStackIn);
                inventorySlots.get(index).func_75215_d(null);
                return true;
            }
        }
        return false;
    }

    public static boolean moveStackToInventory(ItemStack itemStackIn, List<Slot> inventorySlots) {
        for (int i = 0; i <= 36; ++i) {
            Slot possiblyOpenSlot = inventorySlots.get(i);
            if (possiblyOpenSlot.func_75216_d()) continue;
            possiblyOpenSlot.func_75215_d(itemStackIn);
            return true;
        }
        return false;
    }

    public static int getNextAvailableSlot(List<Slot> inventorySlots) {
        for (int i = 36; i <= 63; ++i) {
            Slot s = inventorySlots.get(i);
            if (s == null || s.func_75211_c() != null) continue;
            return i;
        }
        return -1;
    }

    public static boolean isCustomSlot(int index, boolean withArmor, boolean withOffHand) {
        return index >= (withArmor ? 40 : (withOffHand ? 41 : 36));
    }

    public static boolean isCustomSlot(int index, boolean withArmor) {
        return InventoryUtils.isCustomSlot(index, withArmor, false);
    }

    public static boolean isCustomSlot(int index) {
        return InventoryUtils.isCustomSlot(index, false, false);
    }

    public static boolean isItemHandler(TileEntity tile) {
        return InventoryUtils.isItemHandler(tile, null);
    }

    public static boolean isItemHandler(TileEntity tile, @Nullable EnumFacing facing) {
        return tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
    }

    public static boolean isInventory(TileEntity tile) {
        return tile instanceof IInventory;
    }

    public static boolean hasItemStorage(TileEntity tile, EnumFacing facing) {
        return InventoryUtils.isItemHandler(tile, facing) || InventoryUtils.isInventory(tile);
    }

    public static IItemHandler getItemHandler(TileEntity tile, EnumFacing facing) {
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
        }
        if (tile instanceof ISidedInventory) {
            return InventoryUtils.getWrappedInventory((IInventory)((ISidedInventory)tile), facing);
        }
        if (tile instanceof IInventory) {
            return InventoryUtils.getWrappedInventory((IInventory)tile);
        }
        return null;
    }

    public static IItemHandler getWrappedInventory(IInventory inventory) {
        return InventoryUtils.getWrappedInventory(inventory, null);
    }

    public static IItemHandler getWrappedInventory(IInventory inventory, @Nullable EnumFacing facing) {
        if (inventory instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)inventory, facing);
        }
        return new InvWrapper(inventory);
    }

    public static boolean addItemStack(ItemStack[] inventory, ItemStack stack, int startIndex, int endIndex) {
        if (stack == null) {
            return true;
        }
        int openSlot = -1;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)inventory[i]) && inventory[i].func_77976_d() > inventory[i].field_77994_a) {
                int hold = inventory[i].func_77976_d() - inventory[i].field_77994_a;
                if (hold >= stack.field_77994_a) {
                    inventory[i].field_77994_a += stack.field_77994_a;
                    stack = null;
                    return true;
                }
                stack.field_77994_a -= hold;
                inventory[i].field_77994_a += hold;
                continue;
            }
            if (inventory[i] != null || openSlot != -1) continue;
            openSlot = i;
        }
        if (openSlot < 0) {
            return false;
        }
        inventory[openSlot] = stack;
        return true;
    }

    public static ItemStack insertItem(IInventory inventory, ItemStack stack) {
        return InventoryUtils.insertItem(inventory, stack, null);
    }

    public static ItemStack insertItem(IInventory inventory, ItemStack stack, @Nullable EnumFacing side) {
        if (stack == null || inventory == null) {
            return null;
        }
        int stackSize = stack.field_77994_a;
        if (inventory instanceof ISidedInventory) {
            int i;
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int[] slots = sidedInv.func_180463_a(side);
            if (slots == null) {
                return stack;
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                ItemStack existingStack;
                if (!sidedInv.func_180462_a(slots[i], stack, side) || !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)(existingStack = inventory.func_70301_a(slots[i])))) continue;
                stack = InventoryUtils.insertMergeable((IInventory)sidedInv, slots[i], stack, existingStack);
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                if (inventory.func_70301_a(slots[i]) != null || !sidedInv.func_180462_a(slots[i], stack, side)) continue;
                stack = InventoryUtils.insertEmpty((IInventory)sidedInv, slots[i], stack);
            }
        } else {
            int i;
            int invSize = inventory.func_70302_i_();
            for (i = 0; i < invSize && stack != null; ++i) {
                ItemStack existingStack = inventory.func_70301_a(i);
                if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)existingStack)) continue;
                stack = InventoryUtils.insertMergeable(inventory, i, stack, existingStack);
            }
            for (i = 0; i < invSize && stack != null; ++i) {
                if (inventory.func_70301_a(i) != null) continue;
                stack = InventoryUtils.insertEmpty(inventory, i, stack);
            }
        }
        if (stack == null || stack.field_77994_a != stackSize) {
            inventory.func_70296_d();
        }
        return stack;
    }

    public static boolean hasRoomForStack(TileEntity te, ItemStack stack) {
        if (InventoryUtils.isItemHandler(te)) {
            if (InventoryUtils.hasRoomForStack(InventoryUtils.getItemHandler(te, null), stack)) {
                return true;
            }
            for (int i = 0; i < EnumFacing.values().length; ++i) {
                if (!InventoryUtils.hasRoomForStack(InventoryUtils.getItemHandler(te, EnumFacing.values()[i]), stack)) continue;
                return true;
            }
        }
        if (InventoryUtils.isInventory(te)) {
            return InventoryUtils.hasRoomForStack((IInventory)te, stack);
        }
        return false;
    }

    public static boolean hasRoomForStack(IInventory inventory, ItemStack stack) {
        IInventory tempInventory;
        if (stack == null) {
            return false;
        }
        Object object = tempInventory = inventory instanceof ISidedInventory ? InventoryUtils.getSidedInventoryCopy((ISidedInventory)inventory) : InventoryUtils.getInventoryCopy(inventory);
        if (!(inventory instanceof ISidedInventory)) {
            return !ItemUtils.areStacksSameSize(stack.func_77946_l(), InventoryUtils.insertItem(tempInventory, stack.func_77946_l()));
        }
        if (InventoryUtils.isInventoryValidForItem((ISidedInventory)tempInventory, stack.func_77946_l(), null)) {
            return true;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!InventoryUtils.isInventoryValidForItem((ISidedInventory)tempInventory, stack.func_77946_l(), facing)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInventoryValidForItem(ISidedInventory inv, ItemStack stack, @Nullable EnumFacing facing) {
        boolean canInsert = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!inv.func_180462_a(i, stack, facing)) continue;
            canInsert = true;
            break;
        }
        return InventoryUtils.isInventoryValidForItem((IInventory)inv, stack) && inv.func_180463_a(facing).length > 0 && canInsert;
    }

    public static boolean isInventoryValidForItem(IInventory inv, ItemStack stack) {
        boolean hasAvailableSlot = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null && inv.func_94041_b(i, stack)) {
                hasAvailableSlot = true;
                break;
            }
            ItemStack slotStack = inv.func_70301_a(i);
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)slotStack) || slotStack.field_77994_a >= slotStack.func_77976_d()) continue;
            hasAvailableSlot = true;
            break;
        }
        return hasAvailableSlot;
    }

    public static boolean isInventoryValidForItem(IItemHandler handler, ItemStack stack) {
        boolean hasAvailableSlot = false;
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i) == null) {
                hasAvailableSlot = true;
                break;
            }
            ItemStack slotStack = handler.getStackInSlot(i);
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)slotStack) || slotStack.field_77994_a >= slotStack.func_77976_d()) continue;
            hasAvailableSlot = true;
            break;
        }
        return hasAvailableSlot;
    }

    public static boolean hasRoomForStack(IItemHandler handler, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Object tempHandler = null;
        tempHandler = handler instanceof IItemHandlerModifiable ? InventoryUtils.getItemHandlerModifiableCopy((IItemHandlerModifiable)handler) : InventoryUtils.getItemHandlerCopy(handler);
        return InventoryUtils.isInventoryValidForItem(tempHandler, stack);
    }

    public static IItemHandlerModifiable getItemHandlerModifiableCopy(final IItemHandlerModifiable handler) {
        return new IItemHandlerModifiable(){

            public int getSlots() {
                return handler.getSlots();
            }

            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(slot);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return handler.insertItem(slot, stack, simulate);
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return handler.extractItem(slot, amount, simulate);
            }

            public void setStackInSlot(int slot, ItemStack stack) {
                handler.setStackInSlot(slot, stack);
            }
        };
    }

    public static IItemHandler getItemHandlerCopy(final IItemHandler handler) {
        return new IItemHandler(){

            public int getSlots() {
                return handler.getSlots();
            }

            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(slot);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return handler.insertItem(slot, stack, simulate);
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return handler.extractItem(slot, amount, simulate);
            }
        };
    }

    public static IInventory getInventoryCopy(final IInventory inventory) {
        return new IInventory(){

            public String func_70005_c_() {
                return inventory.func_70005_c_();
            }

            public boolean func_145818_k_() {
                return inventory.func_145818_k_();
            }

            public ITextComponent func_145748_c_() {
                return inventory.func_145748_c_();
            }

            public int func_70302_i_() {
                return inventory.func_70302_i_();
            }

            public ItemStack func_70301_a(int index) {
                return inventory.func_70301_a(index);
            }

            public ItemStack func_70298_a(int index, int count) {
                return inventory.func_70298_a(index, count);
            }

            public ItemStack func_70304_b(int index) {
                return inventory.func_70304_b(index);
            }

            public void func_70299_a(int index, ItemStack stack) {
                inventory.func_70299_a(index, stack);
            }

            public int func_70297_j_() {
                return inventory.func_70297_j_();
            }

            public void func_70296_d() {
                inventory.func_70296_d();
            }

            public boolean func_70300_a(EntityPlayer player) {
                return inventory.func_70300_a(player);
            }

            public void func_174889_b(EntityPlayer player) {
                inventory.func_174889_b(player);
            }

            public void func_174886_c(EntityPlayer player) {
                inventory.func_174886_c(player);
            }

            public boolean func_94041_b(int index, ItemStack stack) {
                return inventory.func_94041_b(index, stack);
            }

            public int func_174887_a_(int id) {
                return inventory.func_174887_a_(id);
            }

            public void func_174885_b(int id, int value) {
                inventory.func_174885_b(id, value);
            }

            public int func_174890_g() {
                return inventory.func_174890_g();
            }

            public void func_174888_l() {
                inventory.func_174888_l();
            }
        };
    }

    public static ISidedInventory getSidedInventoryCopy(final ISidedInventory inventory) {
        return new ISidedInventory(){

            public String func_70005_c_() {
                return inventory.func_70005_c_();
            }

            public boolean func_145818_k_() {
                return inventory.func_145818_k_();
            }

            public ITextComponent func_145748_c_() {
                return inventory.func_145748_c_();
            }

            public int func_70302_i_() {
                return inventory.func_70302_i_();
            }

            public ItemStack func_70301_a(int index) {
                return inventory.func_70301_a(index);
            }

            public ItemStack func_70298_a(int index, int count) {
                return inventory.func_70298_a(index, count);
            }

            public ItemStack func_70304_b(int index) {
                return inventory.func_70304_b(index);
            }

            public void func_70299_a(int index, ItemStack stack) {
                inventory.func_70299_a(index, stack);
            }

            public int func_70297_j_() {
                return inventory.func_70297_j_();
            }

            public void func_70296_d() {
                inventory.func_70296_d();
            }

            public boolean func_70300_a(EntityPlayer player) {
                return inventory.func_70300_a(player);
            }

            public void func_174889_b(EntityPlayer player) {
                inventory.func_174889_b(player);
            }

            public void func_174886_c(EntityPlayer player) {
                inventory.func_174886_c(player);
            }

            public boolean func_94041_b(int index, ItemStack stack) {
                return inventory.func_94041_b(index, stack);
            }

            public int func_174887_a_(int id) {
                return inventory.func_174887_a_(id);
            }

            public void func_174885_b(int id, int value) {
                inventory.func_174885_b(id, value);
            }

            public int func_174890_g() {
                return inventory.func_174890_g();
            }

            public void func_174888_l() {
                inventory.func_174888_l();
            }

            public int[] func_180463_a(EnumFacing side) {
                return inventory.func_180463_a(side);
            }

            public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
                return inventory.func_180462_a(index, itemStackIn, direction);
            }

            public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
                return inventory.func_180461_b(index, stack, direction);
            }
        };
    }

    public static ItemStack insertMergeable(IInventory inventory, int slot, ItemStack stack, ItemStack existingStack) {
        int stackLimit = Math.min(inventory.func_70297_j_(), stack.func_77976_d());
        if (existingStack.field_77994_a >= stackLimit) {
            return stack;
        }
        if (stack.field_77994_a + existingStack.field_77994_a > stackLimit) {
            int stackDiff = stackLimit - existingStack.field_77994_a;
            existingStack.field_77994_a = stackLimit;
            stack.field_77994_a -= stackDiff;
            inventory.func_70299_a(slot, existingStack);
            return stack;
        }
        existingStack.field_77994_a += stack.field_77994_a;
        inventory.func_70299_a(slot, existingStack);
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    public static ItemStack insertEmpty(IInventory inventory, int slot, ItemStack stack) {
        if (!inventory.func_94041_b(slot, stack)) {
            return stack;
        }
        int stackLimit = inventory.func_70297_j_();
        inventory.func_70299_a(slot, stack.func_77946_l());
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    public static ItemStack insertStack(TileEntity tile, ItemStack stack) {
        EnumFacing facing;
        ItemStack returnStack = stack;
        if (!ItemStack.func_77989_b((ItemStack)returnStack, (ItemStack)(stack = InventoryUtils.insertStack(tile, null, stack.func_77946_l())))) {
            return stack;
        }
        EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
        int n = enumFacingArray.length;
        for (int i = 0; i < n && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)(returnStack = InventoryUtils.insertStack(tile, facing = enumFacingArray[i], stack.func_77946_l()))); ++i) {
        }
        return returnStack;
    }

    public static ItemStack insertStack(TileEntity tile, EnumFacing side, ItemStack stack) {
        return InventoryUtils.insertStack(tile, side, stack, false);
    }

    public static ItemStack insertStack(TileEntity tile, EnumFacing side, ItemStack stack, boolean simulate) {
        ItemStack newStack = stack;
        if (stack != null) {
            if (InventoryUtils.isItemHandler(tile, side)) {
                IItemHandler handler = InventoryUtils.getItemHandler(tile, side);
                if (handler != null) {
                    newStack = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)simulate);
                }
            } else if (InventoryUtils.isInventory(tile)) {
                newStack = tile instanceof ISidedInventory ? InventoryUtils.insertItem((IInventory)((ISidedInventory)tile), stack.func_77946_l(), side) : InventoryUtils.insertItem((IInventory)tile, stack.func_77946_l());
            }
        }
        return newStack;
    }

    public static boolean invHasRoomForStack(IItemHandler inv, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stackInSlot = inv.getStackInSlot(slot);
            if (stackInSlot != null) {
                int m;
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot) || stack.field_77994_a >= (m = Math.min(stack.func_77976_d(), inv.getStackInSlot(slot).func_77976_d()) - stackInSlot.field_77994_a)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static ItemStack insertItem(IInventory inv, ItemStack stack, boolean simulate) {
        if (stack == null || inv.func_70302_i_() <= 0) {
            return null;
        }
        int slot = 0;
        if (slot < inv.func_70302_i_()) {
            if (!inv.func_94041_b(slot, stack)) {
                return stack;
            }
            ItemStack stackInSlot = inv.func_70301_a(slot);
            if (stackInSlot != null) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                    return stack;
                }
                int m = Math.min(stack.func_77976_d(), inv.func_70297_j_()) - stackInSlot.field_77994_a;
                if (stack.field_77994_a <= m) {
                    if (!simulate) {
                        ItemStack copy = stack.func_77946_l();
                        copy.field_77994_a += stackInSlot.field_77994_a;
                        inv.func_70299_a(slot, copy);
                        inv.func_70296_d();
                    }
                    return null;
                }
                stack = stack.func_77946_l();
                if (!simulate) {
                    ItemStack copy = stack.func_77979_a(m);
                    copy.field_77994_a += stackInSlot.field_77994_a;
                    inv.func_70299_a(slot, copy);
                    inv.func_70296_d();
                    return stack;
                }
                stack.field_77994_a -= m;
                return stack;
            }
            int m = Math.min(stack.func_77976_d(), inv.func_70297_j_());
            if (m < stack.field_77994_a) {
                stack = stack.func_77946_l();
                if (!simulate) {
                    inv.func_70299_a(slot, stack.func_77979_a(m));
                    inv.func_70296_d();
                    return stack;
                }
                stack.field_77994_a -= m;
                return stack;
            }
            if (!simulate) {
                inv.func_70299_a(slot, stack);
                inv.func_70296_d();
            }
            return null;
        }
        return stack;
    }
}

