/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import p455w0rdslib.util.MathUtils;

public class EntityUtils {
    public static List<Entity> getEntitiesInRange(Class<? extends Entity> entityType, World world, double x, double y, double z, double radius) {
        return world.func_72872_a(entityType, new AxisAlignedBB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius));
    }

    public static IBlockState getBlockStateBelowEntity(Entity entity, int depth) {
        int blockX = MathUtils.floor(entity.field_70165_t);
        int blockY = MathUtils.floor(entity.func_174813_aQ().field_72338_b - (double)depth);
        int blockZ = MathUtils.floor(entity.field_70161_v);
        return entity.field_70170_p.func_180495_p(new BlockPos(blockX, blockY, blockZ));
    }

    public static Block getBlockBelowEntity(Entity entity, int depth) {
        return EntityUtils.getBlockStateBelowEntity(entity, depth).func_177230_c();
    }

    public static IBlockState getBlockStateAboveEntity(Entity entity, int depth) {
        int blockX = MathUtils.floor(entity.field_70165_t);
        int blockY = MathUtils.floor(entity.func_174813_aQ().field_72337_e + (double)depth);
        int blockZ = MathUtils.floor(entity.field_70161_v);
        return entity.field_70170_p.func_180495_p(new BlockPos(blockX, blockY, blockZ));
    }

    public static Block getBlockAboveEntity(Entity entity, int depth) {
        return EntityUtils.getBlockStateAboveEntity(entity, depth).func_177230_c();
    }

    public static boolean isBlockAboveEntity(Entity entity, Block block, int depth) {
        World world = entity.func_130014_f_();
        int blockX = MathUtils.ceil(entity.field_70165_t - 1.0);
        int blockY = MathUtils.ceil(entity.field_70163_u + (double)depth);
        int blockZ = MathUtils.ceil(entity.field_70161_v - 1.0);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!world.func_180495_p(new BlockPos(blockX + i + j, blockY, blockZ + i + j)).func_177230_c().equals(block)) continue;
                return true;
            }
        }
        return false;
    }

    public static BlockPos getPosBelowEntity(Entity entity, int depth) {
        int blockX = MathUtils.floor(entity.field_70165_t);
        int blockY = MathUtils.floor(entity.func_174813_aQ().field_72338_b - (double)depth);
        int blockZ = MathUtils.floor(entity.field_70161_v);
        return new BlockPos(blockX, blockY, blockZ);
    }
}

