/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import p455w0rdslib.capabilities.CapabilityChunkLoader;

public class ChunkUtils {
    private ChunkUtils() {
    }

    public static void register(Object modInstance) {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)modInstance, (ForgeChunkManager.LoadingCallback)Callback.getInstance());
    }

    public static ChunkPos getChunkPos(World world, BlockPos pos) {
        return world.func_175726_f(pos).func_76632_l();
    }

    public static class TicketHandler {
        private static final TicketHandler INSTANCE = new TicketHandler();

        private TicketHandler() {
        }

        public static TicketHandler getInstance() {
            return INSTANCE;
        }

        public ForgeChunkManager.Ticket getTicket(Object modInstnace, World world) {
            return ForgeChunkManager.requestTicket((Object)modInstnace, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }

        public void load(World world, BlockPos pos, ForgeChunkManager.Ticket ticket) {
            if (world != null && !world.field_72995_K && pos != null && !ForgeChunkManager.getPersistentChunksFor((World)world).containsKey((Object)ChunkUtils.getChunkPos(world, pos))) {
                ticket.getModData().func_74768_a("xCoord", pos.func_177958_n());
                ticket.getModData().func_74768_a("yCoord", pos.func_177956_o());
                ticket.getModData().func_74768_a("zCoord", pos.func_177952_p());
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)ChunkUtils.getChunkPos(world, pos));
            }
        }

        public void unload(World world, BlockPos pos, ForgeChunkManager.Ticket ticket) {
            if (world != null && !world.field_72995_K && pos != null && ForgeChunkManager.getPersistentChunksFor((World)world).containsKey((Object)ChunkUtils.getChunkPos(world, pos))) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)ChunkUtils.getChunkPos(world, pos));
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
        }
    }

    public static class Callback
    implements ForgeChunkManager.LoadingCallback {
        private static final Callback INSTANCE = new Callback();

        private Callback() {
        }

        public static Callback getInstance() {
            return INSTANCE;
        }

        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                int z;
                int y;
                int x = ticket.getModData().func_74762_e("xCoord");
                BlockPos pos = new BlockPos(x, y = ticket.getModData().func_74762_e("yCoord"), z = ticket.getModData().func_74762_e("zCoord"));
                TileEntity te = world.func_175625_s(pos);
                if (te == null || !te.hasCapability(CapabilityChunkLoader.CAPABILITY_CHUNKLOADER_TE, null)) continue;
                TicketHandler handler = new TicketHandler();
                FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> handler.load(world, pos, ticket));
            }
        }
    }
}

