/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import p455w0rdslib.api.gui.IGuiElement;
import p455w0rdslib.api.gui.IModularGui;

public class GuiModular
extends GuiContainer
implements IModularGui {
    ResourceLocation backgroundTexture = new ResourceLocation("textures/gui/demo_background.png");
    List<IGuiElement> elements = Lists.newArrayList();
    String title = "";
    float titleScale = 1.0f;
    int titleColor = 0xFFFFFF;
    int tooltipColor1 = -15204499;
    int tooltipColor2 = -1726480531;
    int titleOffsetX = 5;
    int titleOffsetY = 6;

    public GuiModular(Container inventorySlotsIn) {
        super(inventorySlotsIn);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        super.func_73863_a(mouseX, mouseY, partialTick);
        this.updateElements(mouseX, mouseY);
        for (IGuiElement element : this.getElements()) {
            if (!element.hasTooltip() || !this.isMouseOverElement(element, mouseX, mouseY)) continue;
            p455w0rdslib.util.GuiUtils.drawToolTipWithBorderColor((GuiScreen)this, element.getTooltip(), mouseX, mouseY, this.tooltipColor1, this.tooltipColor2);
        }
    }

    @Override
    public void updateElements(int mouseX, int mouseY) {
        int i = this.elements.size();
        while (i-- > 0) {
            IGuiElement c = this.elements.get(i);
            if (!c.isVisible() || !c.isEnabled()) continue;
            c.update(mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        p455w0rdslib.util.GuiUtils.drawScaledString(this.getTitle(), this.titleOffsetX, this.titleOffsetY, this.titleScale, this.titleColor);
        this.drawElements(0.0f, mouseX, mouseY, true);
        GlStateManager.func_179147_l();
        GlStateManager.func_179145_e();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        for (IGuiElement element : this.getElements()) {
            element.onMousePressed(mouseX - (this.field_146294_l - this.field_146999_f) / 2, mouseY - (this.field_146295_m - this.field_147000_g) / 2, mouseButton);
        }
        try {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int button) {
        for (IGuiElement element : this.getElements()) {
            element.onMouseReleased(mouseX - (this.field_146294_l - this.field_146999_f) / 2, mouseY - (this.field_146295_m - this.field_147000_g) / 2, button);
        }
        super.func_146286_b(mouseX, mouseY, button);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        p455w0rdslib.util.GuiUtils.bindTexture(this.backgroundTexture);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawElements(partialTicks, x, y, false);
        GlStateManager.func_179121_F();
    }

    @Override
    public int getX() {
        return this.field_147003_i;
    }

    @Override
    public int getY() {
        return this.field_147009_r;
    }

    @Override
    public int getWidth() {
        return this.field_146999_f;
    }

    @Override
    public int getHeight() {
        return this.field_147000_g;
    }

    @Override
    public IModularGui setTitleScale(float scale) {
        this.titleScale = scale;
        return this;
    }

    @Override
    public IModularGui setTitleOffsetX(int offset) {
        this.titleOffsetX = offset;
        return this;
    }

    @Override
    public IModularGui setTitleOffsetY(int offset) {
        this.titleOffsetY = offset;
        return this;
    }

    @Override
    public IModularGui setTitlePos(int x, int y) {
        return this.setTitleOffsetX(x).setTitleOffsetY(y);
    }

    @Override
    public IModularGui setWidth(int w) {
        this.field_146999_f = w;
        return this;
    }

    @Override
    public IModularGui setHeight(int h) {
        this.field_147000_g = h;
        return this;
    }

    @Override
    public IModularGui setSize(int w, int h) {
        return this.setWidth(w).setHeight(h);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IModularGui setTitle(String titleText) {
        this.title = titleText;
        return this;
    }

    @Override
    public int getTitleColor() {
        return this.titleColor;
    }

    @Override
    public IModularGui setTitleColor(int color) {
        this.titleColor = color;
        return this;
    }

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.backgroundTexture;
    }

    @Override
    public IModularGui setBackgroundTexture(ResourceLocation location) {
        this.backgroundTexture = location;
        return this;
    }

    public boolean func_146981_a(Slot slotIn, int mouseX, int mouseY) {
        return this.isMouseOver(slotIn.field_75223_e, slotIn.field_75221_f, 16, 16, mouseX, mouseY);
    }

    @Override
    public boolean isMouseOverElement(IGuiElement element, int mouseX, int mouseY) {
        return this.isMouseOver(element.getX(), element.getY(), element.getWidth(), element.getHeight(), mouseX, mouseY);
    }

    @Override
    public boolean isMouseOver(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        return super.func_146978_c(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        List list = stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, stack.func_77953_t().field_77937_e + (String)list.get(i));
                continue;
            }
            list.set(i, TextFormatting.GRAY + (String)list.get(i));
        }
        GuiUtils.preItemToolTip((ItemStack)stack);
        p455w0rdslib.util.GuiUtils.drawToolTipWithBorderColor((GuiScreen)this, list, x, y, this.tooltipColor1, this.tooltipColor2);
        GuiUtils.postItemToolTip();
    }

    @Override
    public void drawElements(float partialTick, int mouseX, int mouseY, boolean foreground) {
        if (foreground) {
            for (int i = 0; i < this.elements.size(); ++i) {
                IGuiElement element = this.elements.get(i);
                if (!element.isVisible()) continue;
                element.drawForeground(mouseX, mouseY);
            }
        } else {
            for (int i = 0; i < this.elements.size(); ++i) {
                IGuiElement element = this.elements.get(i);
                if (!element.isVisible()) continue;
                element.drawBackground(mouseX, mouseY, partialTick);
            }
        }
    }

    @Override
    public IModularGui addElement(IGuiElement element) {
        this.elements.add(element);
        return this;
    }

    @Override
    public List<IGuiElement> getElements() {
        return this.elements;
    }

    @Override
    public IModularGui setTooltipColor(int color, boolean top) {
        if (top) {
            this.tooltipColor1 = color;
        } else {
            this.tooltipColor2 = color;
        }
        return this;
    }

    @Override
    public int[] getTooltipColors() {
        return new int[]{this.tooltipColor1, this.tooltipColor2};
    }

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int wheelMovement) {
        return false;
    }

    public void func_146274_d() throws IOException {
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int mouseX = x - this.field_147003_i;
        int mouseY = y - this.field_147009_r;
        int wheelMovement = Mouse.getEventDWheel();
        if (wheelMovement != 0) {
            int i = this.elements.size();
            while (i-- > 0) {
                IGuiElement c = this.elements.get(i);
                if (!c.isVisible() || !c.isEnabled() || !c.isMouseOver(mouseX, mouseY) || !c.onMouseWheel(mouseX, mouseY, wheelMovement)) continue;
                return;
            }
            if (this.onMouseWheel(mouseX, mouseY, wheelMovement)) {
                return;
            }
        }
        super.func_146274_d();
    }
}

