/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.client.models.blocks;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lumien.randomthings.client.RenderReference;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.MinecraftForgeClient;

public class ModelCubeOverlay
implements IBakedModel {
    boolean isAmbientOcclusion;
    TextureAtlasSprite particleTexture;
    HashMap<EnumFacing, List<BakedQuad>> itemQuads;
    Map<EnumFacing, List<BakedQuad>> originalQuads;
    Map<EnumFacing, List<BakedQuad>> overlayQuads;

    public ModelCubeOverlay(Map<EnumFacing, List<BakedQuad>> originalQuads, HashMap<EnumFacing, TextureAtlasSprite> overlays, TextureAtlasSprite particleTexture, boolean isAmbientOcclusion) {
        this.originalQuads = originalQuads;
        this.itemQuads = new HashMap();
        this.particleTexture = particleTexture;
        this.isAmbientOcclusion = isAmbientOcclusion;
        this.overlayQuads = new HashMap<EnumFacing, List<BakedQuad>>();
        this.itemQuads.put(null, originalQuads.get(null));
        for (EnumFacing f : EnumFacing.values()) {
            List<BakedQuad> facingQuads = originalQuads.get(f);
            this.itemQuads.put(f, new ArrayList(originalQuads.get(f)));
            originalQuads.put(f, new ArrayList(originalQuads.get(f)));
        }
        for (EnumFacing f : EnumFacing.values()) {
            if (!overlays.containsKey(f)) continue;
            BakedQuad overlayQuad = this.createSidedBakedQuad(0.0f, 1.0f, 0.0f, 1.0f, 1.0f, overlays.get(f), f);
            ArrayList<BakedQuad> sideQuadList = new ArrayList<BakedQuad>();
            this.overlayQuads.put(f, sideQuadList);
            sideQuadList.add(overlayQuad);
            this.itemQuads.get(f).add(overlayQuad);
        }
    }

    private int[] vertexToInts(float x, float y, float z, int color, TextureAtlasSprite texture, float u, float v, EnumFacing side) {
        int xN = (byte)(side.func_82601_c() * 127) & 0xFF;
        int yN = (byte)(side.func_96559_d() * 127) & 0xFF;
        int zN = (byte)(side.func_82599_e() * 127) & 0xFF;
        int normal = xN | yN << 8 | zN << 16;
        return new int[]{Float.floatToRawIntBits(x), Float.floatToRawIntBits(y), Float.floatToRawIntBits(z), color, Float.floatToRawIntBits(texture.func_94214_a((double)u)), Float.floatToRawIntBits(texture.func_94207_b((double)v)), normal};
    }

    private BakedQuad createSidedBakedQuad(float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, EnumFacing side) {
        Vec3d c1 = ModelCubeOverlay.rotate(new Vec3d((double)x1 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d c2 = ModelCubeOverlay.rotate(new Vec3d((double)x1 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d c3 = ModelCubeOverlay.rotate(new Vec3d((double)x2 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d c4 = ModelCubeOverlay.rotate(new Vec3d((double)x2 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        EnumFacing rotation = EnumFacing.SOUTH;
        if (side == EnumFacing.WEST || side == EnumFacing.EAST || side == EnumFacing.SOUTH) {
            rotation = EnumFacing.SOUTH;
        } else if (side == EnumFacing.NORTH) {
            rotation = EnumFacing.WEST;
            c1 = ModelCubeOverlay.rotate(c1.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c2 = ModelCubeOverlay.rotate(c2.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c3 = ModelCubeOverlay.rotate(c3.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c4 = ModelCubeOverlay.rotate(c4.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
        }
        if (side != EnumFacing.UP && side != EnumFacing.SOUTH) {
            c1 = ModelCubeOverlay.rotate(c1.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c2 = ModelCubeOverlay.rotate(c2.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c3 = ModelCubeOverlay.rotate(c3.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
            c4 = ModelCubeOverlay.rotate(c4.func_72441_c(-0.5, -0.5, -0.5), rotation).func_72441_c(0.5, 0.5, 0.5);
        }
        return new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts((float)c1.field_72450_a, (float)c1.field_72448_b, (float)c1.field_72449_c, -1, texture, 0.0f, 0.0f, side), this.vertexToInts((float)c2.field_72450_a, (float)c2.field_72448_b, (float)c2.field_72449_c, -1, texture, 0.0f, 16.0f, side), this.vertexToInts((float)c3.field_72450_a, (float)c3.field_72448_b, (float)c3.field_72449_c, -1, texture, 16.0f, 16.0f, side), this.vertexToInts((float)c4.field_72450_a, (float)c4.field_72448_b, (float)c4.field_72449_c, -1, texture, 16.0f, 0.0f, side)}), -1, side, texture, false, DefaultVertexFormats.field_176599_b);
    }

    public boolean func_177555_b() {
        return this.isAmbientOcclusion;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particleTexture;
    }

    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return RenderReference.BLOCK_ITEM_TRANSFORM;
    }

    private static Vec3d rotate(Vec3d vec, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3d(vec.field_72450_a, -vec.field_72448_b, -vec.field_72449_c);
            }
            case UP: {
                return new Vec3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
            case NORTH: {
                return new Vec3d(vec.field_72450_a, vec.field_72449_c, -vec.field_72448_b);
            }
            case SOUTH: {
                return new Vec3d(vec.field_72450_a, -vec.field_72449_c, vec.field_72448_b);
            }
            case WEST: {
                return new Vec3d(-vec.field_72448_b, vec.field_72450_a, vec.field_72449_c);
            }
            case EAST: {
                return new Vec3d(vec.field_72448_b, -vec.field_72450_a, vec.field_72449_c);
            }
        }
        return null;
    }

    private static Vec3d revRotate(Vec3d vec, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3d(vec.field_72450_a, -vec.field_72448_b, -vec.field_72449_c);
            }
            case UP: {
                return new Vec3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
            case NORTH: {
                return new Vec3d(vec.field_72450_a, -vec.field_72449_c, vec.field_72448_b);
            }
            case SOUTH: {
                return new Vec3d(vec.field_72450_a, vec.field_72449_c, -vec.field_72448_b);
            }
            case WEST: {
                return new Vec3d(vec.field_72448_b, -vec.field_72450_a, vec.field_72449_c);
            }
            case EAST: {
                return new Vec3d(-vec.field_72448_b, vec.field_72450_a, vec.field_72449_c);
            }
        }
        return null;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (state == null) {
            return this.itemQuads.get(side);
        }
        if (layer == BlockRenderLayer.SOLID) {
            if (this.originalQuads.containsKey(side)) {
                return this.originalQuads.get(side);
            }
        } else if (layer == BlockRenderLayer.TRANSLUCENT && this.overlayQuads.containsKey(side)) {
            return this.overlayQuads.get(side);
        }
        return new ArrayList<BakedQuad>();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

