/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import com.google.common.base.Predicate;
import lumien.randomthings.block.BlockBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockItemRedirector
extends BlockBase {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.5, 0.7);
    public static final PropertyDirection INPUT_FACING = PropertyDirection.func_177712_a((String)"inputfacing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyDirection OUTPUT_FACING = PropertyDirection.func_177712_a((String)"outputfacing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    protected BlockItemRedirector() {
        super("itemRedirector", Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)INPUT_FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OUTPUT_FACING, (Comparable)EnumFacing.SOUTH));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return AABB;
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing currentInput = (EnumFacing)state.func_177229_b((IProperty)INPUT_FACING);
        EnumFacing currentOutput = (EnumFacing)state.func_177229_b((IProperty)OUTPUT_FACING);
        return currentInput.ordinal() - 2 + (currentOutput.ordinal() - 2) * 4;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing output = EnumFacing.values()[meta / 4 + 2];
        EnumFacing input = EnumFacing.values()[meta - (output.ordinal() - 2) * 4 + 2];
        return this.func_176223_P().func_177226_a((IProperty)INPUT_FACING, (Comparable)input).func_177226_a((IProperty)OUTPUT_FACING, (Comparable)output);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{INPUT_FACING, OUTPUT_FACING});
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
        if (entityIn instanceof EntityItem) {
            Vec3d motionVec = new Vec3d(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v).func_178788_d(new Vec3d(entityIn.field_70142_S, entityIn.field_70137_T, entityIn.field_70136_U));
            Vec3d center = new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.0, 0.5);
            Vec3d difVec = center.func_178788_d(entityIn.func_174791_d());
            EnumFacing facing = EnumFacing.func_176737_a((float)((float)difVec.field_72450_a), (float)((float)difVec.field_72448_b), (float)((float)difVec.field_72449_c)).func_176734_d();
            EnumFacing currentInput = (EnumFacing)state.func_177229_b((IProperty)INPUT_FACING);
            EnumFacing currentOutput = (EnumFacing)state.func_177229_b((IProperty)OUTPUT_FACING);
            if (facing == currentInput) {
                Vec3d facingVec = new Vec3d(currentOutput.func_176730_m()).func_186678_a(0.4).func_178787_e(center);
                float dif = facing.func_176734_d().func_185119_l() - currentOutput.func_185119_l();
                Vec3d outputMotionVec = motionVec.func_178785_b((float)Math.toRadians(dif));
                entityIn.func_70107_b(facingVec.field_72450_a, facingVec.field_72448_b, facingVec.field_72449_c);
                entityIn.field_70159_w = outputMotionVec.field_72450_a;
                entityIn.field_70181_x = outputMotionVec.field_72448_b;
                entityIn.field_70179_y = outputMotionVec.field_72449_c;
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (side != EnumFacing.UP && side != EnumFacing.DOWN) {
            EnumFacing currentInput = (EnumFacing)state.func_177229_b((IProperty)INPUT_FACING);
            EnumFacing currentOutput = (EnumFacing)state.func_177229_b((IProperty)OUTPUT_FACING);
            if (currentInput != side && currentOutput != side) {
                if (!worldIn.field_72995_K) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)OUTPUT_FACING, (Comparable)side));
                }
                return true;
            }
        }
        return false;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)INPUT_FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)OUTPUT_FACING, (Comparable)placer.func_174811_aO());
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)INPUT_FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)INPUT_FACING, (Comparable)enumfacing).func_177226_a((IProperty)OUTPUT_FACING, (Comparable)enumfacing.func_176734_d()), 2);
        }
    }
}

