/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.gui;

import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.button.ButtonBack;
import amerifrance.guideapi.button.ButtonNext;
import amerifrance.guideapi.button.ButtonPrev;
import amerifrance.guideapi.gui.GuiBase;
import amerifrance.guideapi.gui.GuiHome;
import amerifrance.guideapi.network.PacketHandler;
import amerifrance.guideapi.network.PacketSyncCategory;
import amerifrance.guideapi.wrapper.EntryWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiCategory
extends GuiBase {
    public ResourceLocation outlineTexture;
    public ResourceLocation pageTexture;
    public Book book;
    public CategoryAbstract category;
    public HashMultimap<Integer, EntryWrapper> entryWrapperMap = HashMultimap.create();
    public ButtonBack buttonBack;
    public ButtonNext buttonNext;
    public ButtonPrev buttonPrev;
    public int entryPage;

    public GuiCategory(Book book, CategoryAbstract category, EntityPlayer player, ItemStack bookStack) {
        super(player, bookStack);
        this.book = book;
        this.category = category;
        this.pageTexture = book.getPageTexture();
        this.outlineTexture = book.getOutlineTexture();
        this.entryPage = 0;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.entryWrapperMap.clear();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.buttonBack = new ButtonBack(0, this.guiLeft + this.xSize / 6, this.guiTop, this);
        this.field_146292_n.add(this.buttonBack);
        this.buttonNext = new ButtonNext(1, this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, this);
        this.field_146292_n.add(this.buttonNext);
        this.buttonPrev = new ButtonPrev(2, this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, this);
        this.field_146292_n.add(this.buttonPrev);
        int eX = this.guiLeft + 37;
        int eY = this.guiTop + 15;
        int i = 0;
        int pageNumber = 0;
        ArrayList entries = Lists.newArrayList(this.category.entries.values());
        for (EntryAbstract entry : entries) {
            entry.onInit(this.book, this.category, this, this.player, this.bookStack);
            this.entryWrapperMap.put((Object)pageNumber, (Object)new EntryWrapper(this, this.book, this.category, entry, eX, eY, 4 * this.xSize / 6, 10, this.player, this.field_146289_q, this.bookStack));
            eY += 13;
            if (++i < 11) continue;
            i = 0;
            eY = this.guiTop + 15;
            ++pageNumber;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float renderPartialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.pageTexture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.outlineTexture);
        this.drawTexturedModalRectWithColor(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize, this.book.getColor());
        for (EntryWrapper wrapper : this.entryWrapperMap.get((Object)this.entryPage)) {
            if (wrapper.canPlayerSee()) {
                wrapper.draw(mouseX, mouseY, this);
                wrapper.drawExtras(mouseX, mouseY, this);
            }
            if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
            wrapper.onHoverOver(mouseX, mouseY);
        }
        this.func_73732_a(this.field_146289_q, String.format("%d/%d", this.entryPage + 1, this.entryWrapperMap.asMap().size()), this.guiLeft + this.xSize / 2, this.guiTop + 5 * this.ySize / 6, 0);
        this.drawCenteredStringWithShadow(this.field_146289_q, this.category.getLocalizedName(), this.guiLeft + this.xSize / 2, this.guiTop - 10, Color.WHITE.getRGB());
        this.buttonPrev.field_146125_m = this.entryPage != 0;
        this.buttonNext.field_146125_m = this.entryPage != this.entryWrapperMap.asMap().size() - 1 && !this.entryWrapperMap.asMap().isEmpty();
        super.func_73863_a(mouseX, mouseY, renderPartialTicks);
    }

    public void func_73864_a(int mouseX, int mouseY, int typeofClick) {
        try {
            super.func_73864_a(mouseX, mouseY, typeofClick);
            for (EntryWrapper wrapper : this.entryWrapperMap.get((Object)this.entryPage)) {
                if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
                if (typeofClick == 0) {
                    wrapper.entry.onLeftClicked(this.book, this.category, mouseX, mouseY, this.player, this);
                    continue;
                }
                if (typeofClick != 1) continue;
                wrapper.entry.onRightClicked(this.book, this.category, mouseX, mouseY, this.player, this);
            }
            if (typeofClick == 1) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiHome(this.book, this.player, this.bookStack));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void func_146274_d() {
        try {
            super.func_146274_d();
            int movement = Mouse.getEventDWheel();
            if (movement < 0) {
                this.nextPage();
            } else if (movement > 0) {
                this.prevPage();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void func_73869_a(char typedChar, int keyCode) {
        super.func_73869_a(typedChar, keyCode);
        if (keyCode == 14 || keyCode == this.field_146297_k.field_71474_y.field_74313_G.func_151463_i()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiHome(this.book, this.player, this.bookStack));
        }
        if ((keyCode == 200 || keyCode == 205) && this.entryPage + 1 < this.entryWrapperMap.asMap().size()) {
            this.nextPage();
        }
        if ((keyCode == 208 || keyCode == 203) && this.entryPage > 0) {
            this.prevPage();
        }
    }

    public void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiHome(this.book, this.player, this.bookStack));
        } else if (button.field_146127_k == 1 && this.entryPage + 1 < this.entryWrapperMap.asMap().size()) {
            this.nextPage();
        } else if (button.field_146127_k == 2 && this.entryPage > 0) {
            this.prevPage();
        }
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSyncCategory(this.book.getCategoryList().indexOf(this.category), this.entryPage));
    }

    public void nextPage() {
        if (this.entryPage >= this.entryWrapperMap.asMap().size()) {
            this.entryPage = this.entryWrapperMap.asMap().size() - 1;
        }
        if (this.entryPage != this.entryWrapperMap.asMap().size() - 1 && !this.entryWrapperMap.asMap().isEmpty()) {
            ++this.entryPage;
        }
    }

    public void prevPage() {
        if (this.entryPage >= this.entryWrapperMap.asMap().size()) {
            this.entryPage = this.entryWrapperMap.asMap().size() - 1;
        }
        if (this.entryPage != 0) {
            --this.entryPage;
        }
    }
}

