/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi;

import amerifrance.guideapi.ConfigHandler;
import amerifrance.guideapi.TestBook;
import amerifrance.guideapi.api.GuideAPI;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.item.ItemGuideBook;
import amerifrance.guideapi.network.PacketHandler;
import amerifrance.guideapi.proxy.CommonProxy;
import amerifrance.guideapi.util.EventHandler;
import java.io.File;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

@Mod(modid="guideapi", name="Guide-API", version="@VERSION@", acceptedMinecraftVersions="[1.10.2]")
public class GuideMod {
    public static final String NAME = "Guide-API";
    public static final String ID = "guideapi";
    public static final String CHANNEL = "GuideAPI";
    public static final String VERSION = "@VERSION@";
    @Mod.Instance(value="guideapi")
    public static GuideMod instance;
    @SidedProxy(clientSide="amerifrance.guideapi.proxy.ClientProxy", serverSide="amerifrance.guideapi.proxy.CommonProxy")
    public static CommonProxy proxy;
    private static File configDir;
    private static boolean isDev;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configDir = new File(event.getModConfigurationDirectory(), NAME);
        configDir.mkdirs();
        ConfigHandler.init(new File(configDir, "Guide-API.cfg"));
        GuideAPI.initialize();
        GuideAPI.guideBook = new ItemGuideBook();
        GameRegistry.register((IForgeRegistryEntry)GuideAPI.guideBook.setRegistryName("ItemGuideBook"));
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        PacketHandler.registerPackets();
        if (GuideMod.isDev()) {
            TestBook.registerTests(5);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.initColors();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ConfigHandler.handleBookConfigs();
    }

    @Mod.EventHandler
    public void onMapping(FMLModIdMappingEvent event) {
        for (Book book : GuideAPI.BOOKS.getValues()) {
            if (book.getMappingFunction() == null) continue;
            book.getMappingFunction().apply((Object)book);
        }
    }

    public static File getConfigDir() {
        return configDir;
    }

    public static boolean isDev() {
        return isDev;
    }

    static {
        isDev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }
}

