/*
 * Decompiled with CFR 0.152.
 */
package exter.fodc.tileentity;

import exter.fodc.ModOreDicConvert;
import exter.fodc.network.MessageODC;
import exter.fodc.registry.OreNameRegistry;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityAutomaticOreConverter
extends TileEntity
implements ITickable,
ISidedInventory {
    private ItemStack[] inventory = new ItemStack[SIZE_INVENTORY];
    private ItemStack[] targets = new ItemStack[SIZE_TARGETS];
    private ItemStack last_input;
    private ItemStack last_target;
    public static int SIZE_INVENTORY = 14;
    public static int SIZE_TARGETS = 18;
    private int process_tick = 0;
    private static final int[] ALL_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};

    private void writeItemToNBT(NBTTagCompound compound, int slot) {
        ItemStack is = this.func_70301_a(slot);
        NBTTagCompound tag = new NBTTagCompound();
        if (is != null) {
            tag.func_74757_a("empty", false);
            is.func_77955_b(tag);
        } else {
            tag.func_74757_a("empty", true);
        }
        compound.func_74782_a("Item_" + String.valueOf(slot), (NBTBase)tag);
    }

    private void writeTargetToNBT(NBTTagCompound compound, int slot) {
        ItemStack is = this.targets[slot];
        NBTTagCompound tag = new NBTTagCompound();
        if (is != null) {
            tag.func_74757_a("empty", false);
            is.func_77955_b(tag);
        } else {
            tag.func_74757_a("empty", true);
        }
        compound.func_74782_a("Target_" + String.valueOf(slot), (NBTBase)tag);
    }

    public void func_145839_a(NBTTagCompound compound) {
        NBTTagCompound tag;
        int i;
        super.func_145839_a(compound);
        for (i = 0; i < this.inventory.length; ++i) {
            NBTTagCompound tag2 = (NBTTagCompound)compound.func_74781_a("Item_" + String.valueOf(i));
            if (tag2 == null) continue;
            ItemStack stack = null;
            if (!tag2.func_74767_n("empty")) {
                stack = ItemStack.func_77949_a((NBTTagCompound)tag2);
            }
            this.func_70299_a(i, stack);
        }
        NBTTagList targets_tag = (NBTTagList)compound.func_74781_a("Targets");
        if (targets_tag != null) {
            this.targets = new ItemStack[SIZE_TARGETS];
            for (i = 0; i < targets_tag.func_74745_c(); ++i) {
                tag = targets_tag.func_150305_b(i);
                int slot = tag.func_74771_c("Slot") & 0xFF;
                ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag);
                is.field_77994_a = 1;
                this.setTarget(slot, is);
            }
        }
        for (i = 0; i < this.targets.length; ++i) {
            tag = (NBTTagCompound)compound.func_74781_a("Target_" + String.valueOf(i));
            if (tag == null) continue;
            ItemStack stack = null;
            if (!tag.func_74767_n("empty")) {
                stack = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
            this.targets[i] = stack;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        int i;
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        super.func_189515_b(compound);
        for (i = 0; i < this.inventory.length; ++i) {
            this.writeItemToNBT(compound, i);
        }
        for (i = 0; i < this.targets.length; ++i) {
            this.writeTargetToNBT(compound, i);
        }
        return compound;
    }

    public int func_70302_i_() {
        return SIZE_INVENTORY;
    }

    public ItemStack func_70301_a(int par1) {
        return this.inventory[par1];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= amount) {
                ItemStack var3 = this.inventory[slot];
                this.inventory[slot] = null;
                this.func_70296_d();
                return var3;
            }
            ItemStack var3 = this.inventory[slot].func_77979_a(amount);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            this.func_70296_d();
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.inventory[index] != null) {
            ItemStack var2 = this.inventory[index];
            this.inventory[index] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.inventory[slot] = item;
        if (item != null && item.field_77994_a > this.func_70297_j_()) {
            item.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : this.func_145835_a(player.field_70165_t, player.field_70163_u, player.field_70161_v) <= 64.0;
    }

    public void func_174889_b(EntityPlayer playerIn) {
        if (!this.field_145850_b.field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            super.func_189515_b(tag);
            for (int i = 0; i < this.targets.length; ++i) {
                this.writeTargetToNBT(tag, i);
            }
            this.sendPacketToPlayers(tag);
        }
    }

    public void func_174886_c(EntityPlayer playerIn) {
        if (!this.field_145850_b.field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            super.func_189515_b(tag);
            for (int i = 0; i < this.targets.length; ++i) {
                this.writeTargetToNBT(tag, i);
            }
            this.sendPacketToPlayers(tag);
        }
    }

    protected void sendPacketToPlayers(NBTTagCompound data) {
        data.func_74768_a("dim", this.field_145850_b.field_73011_w.getDimension());
        ModOreDicConvert.network_channel.sendToAllAround((IMessage)new MessageODC(data), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 192.0));
    }

    protected void sendToServer(NBTTagCompound tag) {
        if (this.field_145850_b.field_72995_K) {
            super.func_189515_b(tag);
            tag.func_74768_a("dim", this.field_145850_b.field_73011_w.getDimension());
            ModOreDicConvert.network_channel.sendToServer((IMessage)new MessageODC(tag));
        }
    }

    private ItemStack findConversionTarget(ItemStack item) {
        if (this.last_input != null && this.last_target != null && item.func_77969_a(this.last_input) && ItemStack.func_77970_a((ItemStack)item, (ItemStack)this.last_input)) {
            return this.last_target;
        }
        Set<String> names = OreNameRegistry.findAllOreNames(item);
        if (names.isEmpty()) {
            this.last_target = this.last_input = item.func_77946_l();
            return item;
        }
        for (ItemStack t : this.targets) {
            Set<String> target_names;
            if (t == null || !names.containsAll(target_names = OreNameRegistry.findAllOreNames(t))) continue;
            this.last_input = item.func_77946_l();
            this.last_target = t;
            return t;
        }
        ItemStack target = item;
        int target_diff = Integer.MAX_VALUE;
        for (String name : names) {
            for (ItemStack stack : OreDictionary.getOres((String)name)) {
                int diff;
                Set<String> target_names = OreNameRegistry.findAllOreNames(stack);
                if (!names.containsAll(target_names) || (diff = names.size() - target_names.size()) >= target_diff) continue;
                target_diff = diff;
                target = stack;
                if (diff != 0) continue;
                this.last_input = item.func_77946_l();
                this.last_target = target;
                return target;
            }
        }
        this.last_input = item.func_77946_l();
        this.last_target = target;
        return target;
    }

    private void processItems() {
        for (int i = 7; i >= 0; --i) {
            ItemStack input = this.inventory[i];
            if (input == null) continue;
            ItemStack target = this.findConversionTarget(input);
            for (int j = 8; j < 14; ++j) {
                ItemStack output = this.inventory[j];
                if (output == null) {
                    this.inventory[j] = target.func_77946_l();
                    this.inventory[j].field_77994_a = input.field_77994_a;
                    this.inventory[i] = null;
                    this.func_70296_d();
                    return;
                }
                if (output.field_77994_a >= output.func_77976_d() || !output.func_77969_a(target) || !ItemStack.func_77970_a((ItemStack)target, (ItemStack)output)) continue;
                int transfer = output.func_77976_d() - output.field_77994_a;
                if (transfer >= input.field_77994_a) {
                    this.inventory[i] = null;
                    output.field_77994_a += input.field_77994_a;
                } else {
                    input.field_77994_a -= transfer;
                    output.field_77994_a += transfer;
                }
                this.func_70296_d();
                return;
            }
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.process_tick = (this.process_tick + 1) % 5;
        if (this.process_tick == 0) {
            this.processItems();
        }
    }

    public void setTarget(int slot, ItemStack target) {
        if (!(slot < 0 || slot >= SIZE_TARGETS || target != null && OreNameRegistry.findAllOreNames(target).isEmpty())) {
            this.targets[slot] = target;
            this.last_input = null;
            this.last_target = null;
            if (this.field_145850_b.field_72995_K) {
                NBTTagCompound tag = new NBTTagCompound();
                this.writeTargetToNBT(tag, slot);
                this.sendToServer(tag);
            }
        }
    }

    public ItemStack getTarget(int slot) {
        if (slot < 0 || slot >= SIZE_TARGETS) {
            return null;
        }
        return this.targets[slot];
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i >= 0 && i < 8;
    }

    public int[] func_180463_a(EnumFacing side) {
        return ALL_SLOTS;
    }

    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing direction) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing direction) {
        return i >= 8 && i < 14;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.func_145839_a(pkt.func_148857_g());
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(null));
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString("Ore Autoconverter");
    }

    public String func_70005_c_() {
        return "Ore Autoconverter";
    }
}

