/*
 * Decompiled with CFR 0.152.
 */
package exter.fodc.jei;

import exter.fodc.registry.OreNameRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreConverterJEI {
    public static List<Wrapper> getRecipes() {
        ArrayList<Wrapper> recipes = new ArrayList<Wrapper>();
        for (String ore : OreNameRegistry.getOreNames()) {
            for (ItemStack ore_stack : OreDictionary.getOres((String)ore)) {
                boolean add = true;
                for (Wrapper re : recipes) {
                    if (!ItemStack.func_179545_c((ItemStack)ore_stack, (ItemStack)re.input_item) || !ItemStack.func_77970_a((ItemStack)ore_stack, (ItemStack)re.input_item)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                recipes.add(new Wrapper(ore_stack));
            }
        }
        return recipes;
    }

    public static class Handler
    implements IRecipeHandler<Wrapper> {
        @Nonnull
        public Class<Wrapper> getRecipeClass() {
            return Wrapper.class;
        }

        @Nonnull
        @Deprecated
        public String getRecipeCategoryUid() {
            return "fodc.oreconverter";
        }

        @Nonnull
        public IRecipeWrapper getRecipeWrapper(@Nonnull Wrapper recipe) {
            return recipe;
        }

        public boolean isRecipeValid(@Nonnull Wrapper recipe) {
            return recipe.getOutputs().size() > 0;
        }

        public String getRecipeCategoryUid(Wrapper recipe) {
            return "fodc.oreconverter";
        }
    }

    public static class Category
    implements IRecipeCategory<Wrapper> {
        @Nonnull
        private final IDrawable background;
        @Nonnull
        private final String localizedName;
        private final IJeiHelpers helpers;

        public Category(IJeiHelpers helpers) {
            this.helpers = helpers;
            IGuiHelper guiHelper = helpers.getGuiHelper();
            ResourceLocation location = new ResourceLocation("fodc", "textures/gui/oc_gui.png");
            this.background = guiHelper.createDrawable(location, 10, 14, 156, 74);
            this.localizedName = Translator.translateToLocal((String)"gui.jei.oreconverter");
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        public void drawExtras(Minecraft minecraft) {
        }

        public void drawAnimations(Minecraft minecraft) {
        }

        @Nonnull
        public String getTitle() {
            return this.localizedName;
        }

        @Nonnull
        public String getUid() {
            return "fodc.oreconverter";
        }

        public void setRecipe(IRecipeLayout recipeLayout, Wrapper recipeWrapper) {
            IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
            guiItemStacks.init(0, true, 1, 10);
            guiItemStacks.setFromRecipe(0, this.helpers.getStackHelper().toItemStackList(recipeWrapper.getInputs().get(0)));
            int i = 0;
            for (ItemStack output : recipeWrapper.getOutputs()) {
                guiItemStacks.init(i + 1, false, 83 + i % 4 * 18, 1 + i / 4 * 18);
                guiItemStacks.setFromRecipe(i + 1, Collections.singletonList(output));
                if (++i != 16) continue;
                break;
            }
        }
    }

    public static class Wrapper
    implements IRecipeWrapper {
        @Nonnull
        private final List<ItemStack> output;
        @Nonnull
        private final List<List<ItemStack>> input;
        @Nonnull
        protected final ItemStack input_item;

        public Wrapper(ItemStack input) {
            this.input = Collections.singletonList(Collections.singletonList(input));
            this.input_item = input;
            this.output = new ArrayList<ItemStack>();
            Set<String> names = OreNameRegistry.findAllOreNames(input);
            if (names.isEmpty()) {
                input = null;
                return;
            }
            block0: for (String n : names) {
                for (ItemStack stack : OreDictionary.getOres((String)n)) {
                    if (ItemStack.func_179545_c((ItemStack)stack, (ItemStack)input) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)input) || !names.containsAll(OreNameRegistry.findAllOreNames(stack))) continue;
                    int j = this.output.size();
                    this.output.add(stack);
                    if (j != 15) continue;
                    break block0;
                }
            }
        }

        @Nonnull
        public List<List<ItemStack>> getInputs() {
            return this.input;
        }

        @Nonnull
        public List<ItemStack> getOutputs() {
            return this.output;
        }

        public List<FluidStack> getFluidInputs() {
            return Collections.emptyList();
        }

        public List<FluidStack> getFluidOutputs() {
            return Collections.emptyList();
        }

        public void drawAnimations(Minecraft minecraft, int recipeWidth, int recipeHeight) {
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return null;
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        }

        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }
}

