/*
 * Decompiled with CFR 0.152.
 */
package exter.fodc.gui;

import exter.fodc.container.ContainerAutomaticOreConverter;
import exter.fodc.registry.OreNameRegistry;
import exter.fodc.tileentity.TileEntityAutomaticOreConverter;
import java.io.IOException;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiAutomaticOreConverter
extends GuiContainer {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("fodc:textures/gui/aoc_gui.png");
    private TileEntityAutomaticOreConverter te_autoconverter;
    private TargetSlot[] target_slots;

    public TargetSlot getTargetSlotAt(int x, int y) {
        for (TargetSlot s : this.target_slots) {
            if (x < s.x + 1 || x > s.x + 17 || y < s.y + 1 || y > s.y + 17) continue;
            return s;
        }
        return null;
    }

    public GuiAutomaticOreConverter(TileEntityAutomaticOreConverter aoc, EntityPlayer player) {
        super((Container)new ContainerAutomaticOreConverter(aoc, player));
        this.field_146291_p = false;
        this.field_147000_g = 210;
        this.te_autoconverter = aoc;
        this.target_slots = new TargetSlot[18];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 9; ++j) {
                int s = i * 9 + j;
                this.target_slots[s] = new TargetSlot(j * 18 + 8, i * 18 + 76, s);
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    protected void func_73864_a(int x, int y, int par3) throws IOException {
        super.func_73864_a(x, y, par3);
        int window_x = (this.field_146294_l - this.field_146999_f) / 2;
        int window_y = (this.field_146295_m - this.field_147000_g) / 2;
        TargetSlot slot = this.getTargetSlotAt(x - window_x, y - window_y);
        if (slot != null) {
            slot.onClick();
        }
    }

    protected void func_146979_b(int par1, int par2) {
        this.field_146289_q.func_78276_b("Ore Autoconverter", 8, 6, 0x404040);
        this.field_146289_q.func_78276_b("Targets", 8, 65, 0x404040);
        this.field_146289_q.func_78276_b("Inventory", 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        int window_x = (this.field_146294_l - this.field_146999_f) / 2;
        int window_y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(window_x, window_y, 0, 0, this.field_146999_f, this.field_147000_g);
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        for (int i = 0; i < 18; ++i) {
            this.target_slots[i].drawSlot();
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
    }

    public class TargetSlot {
        public final int x;
        public final int y;
        public final int position;

        public TargetSlot(int xx, int yy, int pos) {
            this.x = xx;
            this.y = yy;
            this.position = pos;
        }

        public void onClick() {
            ItemStack target_stack;
            ItemStack player_stack = GuiAutomaticOreConverter.this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
            if (player_stack != null && !OreNameRegistry.findAllOreNames(player_stack).isEmpty()) {
                target_stack = player_stack.func_77946_l();
                target_stack.field_77994_a = 1;
            } else {
                target_stack = null;
            }
            GuiAutomaticOreConverter.this.te_autoconverter.setTarget(this.position, target_stack);
        }

        public void drawSlot() {
            ItemStack item = GuiAutomaticOreConverter.this.te_autoconverter.getTarget(this.position);
            if (item != null) {
                int window_x = (GuiAutomaticOreConverter.this.field_146294_l - GuiAutomaticOreConverter.this.field_146999_f) / 2;
                int window_y = (GuiAutomaticOreConverter.this.field_146295_m - GuiAutomaticOreConverter.this.field_147000_g) / 2;
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
                GuiAutomaticOreConverter.this.field_73735_i = 200.0f;
                ((GuiAutomaticOreConverter)GuiAutomaticOreConverter.this).field_146296_j.field_77023_b = 200.0f;
                FontRenderer font = null;
                if (item != null) {
                    font = item.func_77973_b().getFontRenderer(item);
                }
                if (font == null) {
                    font = GuiAutomaticOreConverter.this.field_146289_q;
                }
                GuiAutomaticOreConverter.this.field_146296_j.func_180450_b(item, window_x + this.x, window_y + this.y);
                GuiAutomaticOreConverter.this.field_146296_j.func_180453_a(font, item, window_x + this.x, window_y + this.y, null);
                GuiAutomaticOreConverter.this.field_73735_i = 0.0f;
                ((GuiAutomaticOreConverter)GuiAutomaticOreConverter.this).field_146296_j.field_77023_b = 0.0f;
            }
        }
    }
}

