/*
 * Decompiled with CFR 0.152.
 */
package exter.fodc;

import exter.fodc.block.BlockAutomaticOreConverter;
import exter.fodc.block.BlockOreConversionTable;
import exter.fodc.item.ItemOreConverter;
import exter.fodc.network.MessageODC;
import exter.fodc.proxy.CommonODCProxy;
import exter.fodc.registry.OreNameRegistry;
import exter.fodc.tileentity.TileEntityAutomaticOreConverter;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;

@Mod(modid="fodc", name="Ore Dictionary Converter", version="1.9.1", dependencies="required-after:Forge@[12.18.0.2005,)", acceptedMinecraftVersions="[1.10.2]")
public class ModOreDicConvert {
    public static final String MODID = "fodc";
    public static final String MODNAME = "Ore Dictionary Converter";
    public static final String MODVERSION = "1.9.1";
    public static ItemOreConverter item_oreconverter = null;
    @Mod.Instance(value="fodc")
    public static ModOreDicConvert instance;
    @SidedProxy(clientSide="exter.fodc.proxy.ClientODCProxy", serverSide="exter.fodc.proxy.CommonODCProxy")
    public static CommonODCProxy proxy;
    public static BlockOreConversionTable block_oreconvtable;
    public static BlockAutomaticOreConverter block_oreautoconv;
    public static Logger log;
    public static boolean log_orenames;
    public static SimpleNetworkWrapper network_channel;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log = event.getModLog();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        log_orenames = config.getBoolean("log_names", "general", false, "Log registered ore names.");
        OreNameRegistry.preInit(config);
        config.save();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        block_oreconvtable = new BlockOreConversionTable();
        block_oreautoconv = new BlockAutomaticOreConverter();
        item_oreconverter = new ItemOreConverter();
        GameRegistry.register((IForgeRegistryEntry)item_oreconverter);
        GameRegistry.register((IForgeRegistryEntry)block_oreconvtable);
        GameRegistry.register((IForgeRegistryEntry)block_oreautoconv);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)block_oreconvtable).setRegistryName(block_oreconvtable.getRegistryName()));
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)block_oreautoconv).setRegistryName(block_oreautoconv.getRegistryName()));
        network_channel = NetworkRegistry.INSTANCE.newSimpleChannel("EXTER.FODC");
        network_channel.registerMessage(MessageODC.Handler.class, MessageODC.class, 0, Side.SERVER);
        network_channel.registerMessage(MessageODC.Handler.class, MessageODC.class, 0, Side.CLIENT);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerTileEntity(TileEntityAutomaticOreConverter.class, (String)"AutoOreConverter");
        proxy.init();
        ItemStack iron_stack = new ItemStack(Items.field_151042_j);
        ItemStack redstone_stack = new ItemStack(Items.field_151137_ax);
        ItemStack workbench_stack = new ItemStack(Blocks.field_150462_ai);
        ItemStack wood_stack = new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE);
        ItemStack cobble_stack = new ItemStack(Blocks.field_150347_e, 1, Short.MAX_VALUE);
        ItemStack oreconverter_stack = new ItemStack((Item)item_oreconverter);
        GameRegistry.addRecipe((ItemStack)oreconverter_stack, (Object[])new Object[]{"I", "C", "B", Character.valueOf('I'), iron_stack, Character.valueOf('C'), cobble_stack, Character.valueOf('B'), workbench_stack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)block_oreconvtable), (Object[])new Object[]{"O", "W", Character.valueOf('O'), oreconverter_stack, Character.valueOf('W'), wood_stack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)block_oreautoconv), (Object[])new Object[]{"IOI", "CRC", "ICI", Character.valueOf('I'), iron_stack, Character.valueOf('O'), oreconverter_stack, Character.valueOf('R'), redstone_stack, Character.valueOf('C'), cobble_stack});
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        String[] ore_names;
        for (String name : ore_names = OreDictionary.getOreNames()) {
            if (name == null) {
                log.warn("null name in Ore Dictionary.");
                continue;
            }
            OreNameRegistry.registerOreName(name);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onOreDictionaryRegister(OreDictionary.OreRegisterEvent event) {
        OreNameRegistry.registerOreName(event.getName());
    }
}

